/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.statement;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.expression.Identifier;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.TypeName;

public interface LocalVariableDeclarationStatement extends BlockStatement, ForInit {

  static SimpleLocalVariableDeclaration _var(Class<?> type, Identifier id) {
    checkNotNull(type, "type == null");
    checkNotNull(id, "id == null");
    return SimpleLocalVariableDeclaration.ofUnchecked(ClassName.of(type), id.name());
  }

  static SimpleLocalVariableDeclaration _var(Class<?> type, String name) {
    checkNotNull(type, "type == null");
    checkNotNull(name, "name == null");
    return SimpleLocalVariableDeclaration.ofUnchecked(ClassName.of(type), name);
  }

  static WithInitLocalVariableDeclaration _var(Class<?> type, Identifier id,
      VariableInitializer init) {
    checkNotNull(init, "init == null");
    return _var(type, id).init(init);
  }

  static WithInitLocalVariableDeclaration _var(Class<?> type, String name,
      VariableInitializer init) {
    checkNotNull(init, "init == null");
    return _var(type, name).init(init);
  }

  static SimpleLocalVariableDeclaration _var(TypeName typeName, Identifier id) {
    checkNotNull(typeName, "typeName == null");
    checkNotNull(id, "id == null");
    return SimpleLocalVariableDeclaration.ofUnchecked(typeName, id.name());
  }

  static SimpleLocalVariableDeclaration _var(TypeName typeName, String name) {
    checkNotNull(typeName, "typeName == null");
    checkNotNull(name, "name == null");
    return SimpleLocalVariableDeclaration.ofUnchecked(typeName, name);
  }

  static WithInitLocalVariableDeclaration _var(
      TypeName typeName, Identifier id, VariableInitializer init) {
    checkNotNull(init, "init == null");
    return _var(typeName, id).init(init);
  }

  static WithInitLocalVariableDeclaration _var(
      TypeName typeName, String name, VariableInitializer init) {
    checkNotNull(init, "init == null");
    return _var(typeName, name).init(init);
  }

}
