/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.statement;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.expression.ExpressionCode;

public class WhileStatement extends AbstractControlStatement {

  private WhileStatement(ExpressionCode expression, Block block) {
    super(expression, block);
  }

  public static WhileStatement.Builder _while(ExpressionCode expression) {
    return WhileStatement.builder(expression);
  }

  static Builder builder(ExpressionCode expression) {
    checkNotNull(expression, "expression == null");
    return new Builder(expression);
  }

  @Override
  final String keyword() {
    return "while";
  }

  public static class Builder extends AbstractBuilder<WhileStatement> {

    private Builder(ExpressionCode expression) {
      super(expression);
    }

    @Override
    final WhileStatement bodyImpl(
        ExpressionCode expression, Block block) {
      return new WhileStatement(expression, block);
    }

  }

}
