/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.declaration;

import br.com.objectos.code.java.declaration.InterfaceBodyElement;
import br.com.objectos.code.java.declaration.InterfaceModifier;
import br.com.objectos.code.java.declaration.TypeCode;
import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.io.BodyFormatter;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.type.TypeParameterName;
import br.com.objectos.comuns.collections.GrowableList;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.collections.StreamList;
import br.com.objectos.comuns.lang.Preconditions;

public final class InterfaceCode
extends TypeCode {
    private final InterfaceModifier modifier;
    private final String simpleName;
    private final ImmutableList<TypeParameterName> typeParameters = ImmutableList.empty();
    private final ImmutableList<InterfaceBodyElement> bodyElements;

    private InterfaceCode(Builder builder) {
        this.modifier = builder.modifier();
        this.simpleName = builder.simpleName;
        this.bodyElements = builder.bodyElements();
    }

    public static Builder _interface(String simpleName) {
        return InterfaceCode.builder()._interface(simpleName);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        return w.pushSimpleName(this.simpleName).writeCodeElement(this.modifier).writeWord("interface").writeSimpleNameWith((StreamList<? extends TypeParameterName>)this.typeParameters).writeBlock((Iterable<? extends CodeElement>)this.bodyElements).popSimpleName();
    }

    @Override
    public final String simpleName() {
        return this.simpleName;
    }

    public static final class Builder {
        private final InterfaceModifier.Builder modifier = InterfaceModifier.builder();
        private String simpleName = "Unnamed";
        private final GrowableList<InterfaceBodyElement> bodyElements = GrowableList.newList();
        private BodyFormatter formatter = BodyFormatter.defaultFormatter();

        private Builder() {
        }

        public final Builder _interface(String simpleName) {
            Preconditions.checkNotNull((Object)simpleName, (String)"simpleName == null");
            this.simpleName = simpleName;
            return this;
        }

        public final Builder body(InterfaceBodyElement ... elements) {
            this.bodyElements.fluentAdd((Object[])elements);
            return this;
        }

        public final Builder body(Iterable<InterfaceBodyElement> elements) {
            return this.withBodyElements(elements);
        }

        public final InterfaceCode build() {
            return new InterfaceCode(this);
        }

        public final InterfaceCode buildWith(BodyFormatter formatter) {
            this.formatter = (BodyFormatter)Preconditions.checkNotNull((Object)formatter, (String)"formatter == null");
            return this.build();
        }

        public final Builder withBodyElements(Iterable<InterfaceBodyElement> elements) {
            this.bodyElements.addAll(elements);
            return this;
        }

        public final Builder withModifier(InterfaceModifier modifier) {
            Preconditions.checkNotNull((Object)modifier, (String)"modifier == null");
            this.modifier.withModifier(modifier);
            return this;
        }

        final ImmutableList<InterfaceBodyElement> bodyElements() {
            return this.formatter.format(this.bodyElements, InterfaceBodyElement.class);
        }

        final InterfaceModifier modifier() {
            return this.modifier.build();
        }
    }
}

