/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java;

import br.com.objectos.code.java.declaration.ParameterCode;
import br.com.objectos.code.java.element.Keyword.ThisKeyword;
import br.com.objectos.code.java.element.Keywords;
import br.com.objectos.code.java.element.NewLine;
import br.com.objectos.code.java.element.SuperKeyword;
import br.com.objectos.code.java.expression.Argument;
import br.com.objectos.code.java.expression.ArrayCreationExpression;
import br.com.objectos.code.java.expression.ArrayInitializer;
import br.com.objectos.code.java.expression.Assignment;
import br.com.objectos.code.java.expression.AssignmentOperator;
import br.com.objectos.code.java.expression.ClassInstanceCreationExpression;
import br.com.objectos.code.java.expression.ConditionalAndExpression;
import br.com.objectos.code.java.expression.EmptyExpression;
import br.com.objectos.code.java.expression.EqualityExpression;
import br.com.objectos.code.java.expression.ExpressionCode;
import br.com.objectos.code.java.expression.Expressions;
import br.com.objectos.code.java.expression.Identifier;
import br.com.objectos.code.java.expression.InclusiveOrExpression;
import br.com.objectos.code.java.expression.LambdaBody;
import br.com.objectos.code.java.expression.LambdaExpression;
import br.com.objectos.code.java.expression.LambdaParameter;
import br.com.objectos.code.java.expression.LeftHandSide;
import br.com.objectos.code.java.expression.Literal;
import br.com.objectos.code.java.expression.MethodInvocation;
import br.com.objectos.code.java.expression.MethodReference;
import br.com.objectos.code.java.expression.MethodReferenceReferenceExpression;
import br.com.objectos.code.java.expression.ParenthesizedExpression;
import br.com.objectos.code.java.expression.PreDecrementExpression;
import br.com.objectos.code.java.expression.PreIncrementExpression;
import br.com.objectos.code.java.expression.RelationalExpression;
import br.com.objectos.code.java.expression.StatementExpression;
import br.com.objectos.code.java.expression.ThrowableExpression;
import br.com.objectos.code.java.expression.TypeWitness;
import br.com.objectos.code.java.expression.UnaryExpression;
import br.com.objectos.code.java.expression.UnaryExpressionNotPlusMinus;
import br.com.objectos.code.java.statement.AssertStatement;
import br.com.objectos.code.java.statement.BasicForStatement;
import br.com.objectos.code.java.statement.Block;
import br.com.objectos.code.java.statement.BlockElement;
import br.com.objectos.code.java.statement.BlockStatement;
import br.com.objectos.code.java.statement.BreakStatement;
import br.com.objectos.code.java.statement.CaseSwitchElement;
import br.com.objectos.code.java.statement.ContinueStatement;
import br.com.objectos.code.java.statement.DefaultSwitchElement;
import br.com.objectos.code.java.statement.DoStatement;
import br.com.objectos.code.java.statement.EnhancedForStatement;
import br.com.objectos.code.java.statement.ForInit;
import br.com.objectos.code.java.statement.ForStatement;
import br.com.objectos.code.java.statement.IfStatement;
import br.com.objectos.code.java.statement.IfThenStatement;
import br.com.objectos.code.java.statement.LocalVariableDeclarationStatement;
import br.com.objectos.code.java.statement.Resource;
import br.com.objectos.code.java.statement.ReturnStatement;
import br.com.objectos.code.java.statement.SimpleLocalVariableDeclaration;
import br.com.objectos.code.java.statement.Statement;
import br.com.objectos.code.java.statement.SwitchStatement;
import br.com.objectos.code.java.statement.SynchronizedStatement;
import br.com.objectos.code.java.statement.ThrowStatement;
import br.com.objectos.code.java.statement.TrySimpleElement;
import br.com.objectos.code.java.statement.TryStatement;
import br.com.objectos.code.java.statement.TryWithStatement;
import br.com.objectos.code.java.statement.VariableInitializer;
import br.com.objectos.code.java.statement.WhileStatement;
import br.com.objectos.code.java.statement.WithInitLocalVariableDeclaration;
import br.com.objectos.code.java.type.ArrayTypeName;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.PrimitiveTypeName;
import br.com.objectos.code.java.type.ReferenceTypeName;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.code.java.type.TypeVariableName;

public final class CodeJava {

  private CodeJava() {}

  // misc.

  public static ClassName cn(Class<?> type) {
    return ClassName.of(type);
  }

  public static TypeVariableName tvn(String name) {
    return TypeVariableName.named(name);
  }

  public static EmptyExpression empty() {
    return EmptyExpression.empty();
  }

  public static NewLine nl() {
    return NewLine.single();
  }

  // declaration

  public static ParameterCode param(TypeName typeName, String name) {
    return ParameterCode.of(typeName, name);
  }
  
  // element

  public static SuperKeyword _super() {
    return Keywords._super();
  }

  // expressions

  public static ArrayCreationExpression _new(
      ArrayTypeName type, ExpressionCode dim0) {
    return Expressions._new(type, dim0);
  }

  public static ArrayCreationExpression _new(
      ArrayTypeName type, ExpressionCode dim0, ExpressionCode dim1) {
    return Expressions._new(type, dim0, dim1);
  }

  public static ArrayCreationExpression _new(
      ArrayTypeName type, ExpressionCode dim0, ExpressionCode dim1, ExpressionCode dim2) {
    return Expressions._new(type, dim0, dim1, dim2);
  }

  public static ArrayCreationExpression _new(
      ArrayTypeName type,
      ExpressionCode dim0, ExpressionCode dim1, ExpressionCode dim2, ExpressionCode dim3) {
    return Expressions._new(type, dim0, dim1, dim2, dim3);
  }

  public static ArrayCreationExpression _new(
      ArrayTypeName type, Iterable<? extends ExpressionCode> dims) {
    return Expressions._new(type, dims);
  }

  public static ThisKeyword _this() {
    return ThisKeyword._this();
  }

  public static Identifier _this(String name) {
    return ThisKeyword._this(name);
  }

  public static ArrayInitializer a() {
    return Expressions.a();
  }

  public static ArrayInitializer a(
      VariableInitializer v0) {
    return Expressions.a(v0);
  }

  public static ArrayInitializer a(
      VariableInitializer v0,
      VariableInitializer v1) {
    return Expressions.a(v0, v1);
  }

  public static ArrayInitializer a(
      VariableInitializer v0,
      VariableInitializer v1,
      VariableInitializer v2) {
    return Expressions.a(v0, v1, v2);
  }

  public static ArrayInitializer a(
      VariableInitializer v0,
      VariableInitializer v1,
      VariableInitializer v2,
      VariableInitializer v3) {
    return Expressions.a(v0, v1, v2, v3);
  }

  public static ArrayInitializer a(
      VariableInitializer v0,
      VariableInitializer v1,
      VariableInitializer v2,
      VariableInitializer v3,
      VariableInitializer v4) {
    return Expressions.a(v0, v1, v2, v3, v4);
  }

  public static ArrayInitializer a(
      VariableInitializer v0,
      VariableInitializer v1,
      VariableInitializer v2,
      VariableInitializer v3,
      VariableInitializer v4,
      VariableInitializer v5) {
    return Expressions.a(v0, v1, v2, v3, v4, v5);
  }

  public static ArrayInitializer a(
      VariableInitializer v0,
      VariableInitializer v1,
      VariableInitializer v2,
      VariableInitializer v3,
      VariableInitializer v4,
      VariableInitializer v5,
      VariableInitializer v6) {
    return Expressions.a(v0, v1, v2, v3, v4, v5, v6);
  }

  public static ArrayInitializer a(VariableInitializer... elements) {
    return Expressions.a(elements);
  }

  public static ConditionalAndExpression and(
      ConditionalAndExpression lhs, InclusiveOrExpression rhs) {
    return Expressions.and(lhs, rhs);
  }

  public static Assignment assign(LeftHandSide lhs, ExpressionCode expression) {
    return Expressions.assign(lhs, expression);
  }

  public static Assignment assign(
      AssignmentOperator operator, LeftHandSide lhs, ExpressionCode expression) {
    return Expressions.assign(operator, lhs, expression);
  }

  // ClassInstanceCreationExpression

  public static ClassInstanceCreationExpression _new(
      ClassName className) {
    return Expressions._new(className);
  }

  public static ClassInstanceCreationExpression _new(
      ClassName className,
      Argument a1) {
    return Expressions._new(className, a1);
  }

  public static ClassInstanceCreationExpression _new(
      ClassName className,
      Argument a1, Argument a2) {
    return Expressions._new(className, a1, a2);
  }

  public static ClassInstanceCreationExpression _new(
      ClassName className,
      Argument a1, Argument a2, Argument a3) {
    return Expressions._new(className, a1, a2, a3);
  }

  public static ClassInstanceCreationExpression _new(
      ClassName className,
      Argument a1, Argument a2, Argument a3, Argument a4) {
    return Expressions._new(className, a1, a2, a3, a4);
  }

  public static ClassInstanceCreationExpression _new(
      ClassName className,
      Iterable<? extends Argument> args) {
    return Expressions._new(className, args);
  }

  public static ClassInstanceCreationExpression _new(
      ClassName className, TypeWitness witness) {
    return Expressions._new(className, witness);
  }

  public static ClassInstanceCreationExpression _new(
      ClassName className, TypeWitness witness,
      Argument a1) {
    return Expressions._new(className, witness, a1);
  }

  public static ClassInstanceCreationExpression _new(
      ClassName className, TypeWitness witness,
      Argument a1, Argument a2) {
    return Expressions._new(className, witness, a1, a2);
  }

  public static ClassInstanceCreationExpression _new(
      ClassName className, TypeWitness witness,
      Argument a1, Argument a2, Argument a3) {
    return Expressions._new(className, witness, a1, a2, a3);
  }

  public static ClassInstanceCreationExpression _new(
      ClassName className, TypeWitness witness,
      Argument a1, Argument a2, Argument a3, Argument a4) {
    return Expressions._new(className, witness, a1, a2, a3, a4);
  }

  public static ClassInstanceCreationExpression _new(
      ClassName className, TypeWitness witness,
      Iterable<? extends Argument> args) {
    return Expressions._new(className, witness, args);
  }

  public static EqualityExpression eq(EqualityExpression lhs, RelationalExpression rhs) {
    return Expressions.eq(lhs, rhs);
  }

  public static Identifier id(String name) {
    return Expressions.id(name);
  }

  // LambdaExpression

  public static LambdaExpression lambda(
      LambdaBody body) {
    return Expressions.lambda(body);
  }

  public static LambdaExpression lambda(
      Identifier p1,
      LambdaBody body) {
    return Expressions.lambda(p1, body);
  }

  public static LambdaExpression lambda(
      ParameterCode p1,
      LambdaBody body) {
    return Expressions.lambda(p1, body);
  }

  public static LambdaExpression lambda(
      LambdaParameter p1, LambdaParameter p2,
      LambdaBody body) {
    return Expressions.lambda(p1, p2, body);
  }

  public static LambdaExpression lambda(
      LambdaParameter p1, LambdaParameter p2, LambdaParameter p3,
      LambdaBody body) {
    return Expressions.lambda(p1, p2, p3, body);
  }

  public static LambdaExpression lambda(
      LambdaParameter p1, LambdaParameter p2, LambdaParameter p3, LambdaParameter p4,
      LambdaBody body) {
    return Expressions.lambda( p1, p2, p3, p4, body);
  }

  public static LambdaExpression lambda(
      Iterable<? extends LambdaParameter> params,
      LambdaBody body) {
    return Expressions.lambda(params, body);
  }

  public static MethodInvocation invoke(
      String methodName) {
    return Expressions.invoke(methodName);
  }

  public static MethodInvocation invoke(
      String methodName,
      Argument a1) {
    return Expressions.invoke(methodName, a1);
  }

  public static MethodInvocation invoke(
      String methodName,
      Argument a1, Argument a2) {
    return Expressions.invoke(methodName, a1, a2);
  }

  public static MethodInvocation invoke(
      String methodName,
      Argument a1, Argument a2, Argument a3) {
    return Expressions.invoke(methodName, a1, a2, a3);
  }

  public static MethodInvocation invoke(
      String methodName,
      Argument a1, Argument a2, Argument a3, Argument a4) {
    return Expressions.invoke(methodName, a1, a2, a3, a4);
  }

  public static MethodInvocation invoke(
      String methodName, Iterable<? extends Argument> args) {
    return Expressions.invoke(methodName, args);
  }

  // MethodReference
  
  public static MethodReference ref(
      MethodReferenceReferenceExpression expression, String methodName) {
    return Expressions.ref(expression, methodName);
  }

  public static MethodReference ref(
      MethodReferenceReferenceExpression expression, TypeWitness witness, String methodName) {
    return Expressions.ref(expression, witness, methodName);
  }

  public static MethodReference ref(
      ReferenceTypeName typeName, String methodName) {
    return Expressions.ref(typeName, methodName);
  }
  
  public static MethodReference ref(
      ReferenceTypeName typeName, TypeWitness witness, String methodName) {
    return Expressions.ref(typeName, witness, methodName);
  }
  
  public static Literal l(boolean value) {
    return Expressions.l(value);
  }

  public static Literal l(char value) {
    return Expressions.l(value);
  }

  public static Literal l(double value) {
    return Expressions.l(value);
  }

  public static Literal l(int value) {
    return Expressions.l(value);
  }

  public static Literal l(float value) {
    return Expressions.l(value);
  }

  public static Literal l(long value) {
    return Expressions.l(value);
  }

  public static Literal l(Class<?> type) {
    return Expressions.l(type);
  }

  public static Literal l(ClassName className) {
    return Expressions.l(className);
  }

  public static Literal l(String s) {
    return Expressions.l(s);
  }

  // ParenthesizedExpression

  public static ParenthesizedExpression parens(ExpressionCode expression) {
    return Expressions.parens(expression);
  }
  
  // PreDecrementExpression

  public static PreDecrementExpression preDec(UnaryExpression expression) {
    return Expressions.preDec(expression);
  }

  // PreIncrementExpression

  public static PreIncrementExpression preInc(UnaryExpression expression) {
    return Expressions.preInc(expression);
  }
  
  // TypeWitness

  public static TypeWitness hint() {
    return Expressions.hint();
  }

  public static TypeWitness hint(TypeName t1) {
    return Expressions.hint(t1);
  }

  public static TypeWitness hint(TypeName t1, TypeName t2) {
    return Expressions.hint(t1, t2);
  }

  public static TypeWitness hint(TypeName t1, TypeName t2, TypeName t3) {
    return Expressions.hint(t1, t2, t3);
  }

  public static TypeWitness hint(Iterable<? extends TypeName> types) {
    return Expressions.hint(types);
  }

  public static TypeWitness witness() {
    return Expressions.witness();
  }

  public static TypeWitness witness(TypeName t1) {
    return Expressions.witness(t1);
  }

  public static TypeWitness witness(TypeName t1, TypeName t2) {
    return Expressions.witness(t1, t2);
  }

  public static TypeWitness witness(TypeName t1, TypeName t2, TypeName t3) {
    return Expressions.witness(t1, t2, t3);
  }

  public static TypeWitness witness(Iterable<? extends TypeName> types) {
    return Expressions.witness(types);
  }

  // UnaryExpression

  public static UnaryExpressionNotPlusMinus not(UnaryExpression expression) {
    return Expressions.not(expression);
  }

  public static UnaryExpression unaryMinus(UnaryExpression expression) {
    return Expressions.unaryMinus(expression);
  }
  
  public static UnaryExpression unaryPlus(UnaryExpression expression) {
    return Expressions.unaryPlus(expression);
  }

  // primitives

  public static PrimitiveTypeName _boolean() {
    return PrimitiveTypeName.BOOLEAN;
  }

  public static PrimitiveTypeName _byte() {
    return PrimitiveTypeName.BYTE;
  }

  public static PrimitiveTypeName _short() {
    return PrimitiveTypeName.SHORT;
  }

  public static PrimitiveTypeName _int() {
    return PrimitiveTypeName.INT;
  }

  public static PrimitiveTypeName _long() {
    return PrimitiveTypeName.LONG;
  }

  public static PrimitiveTypeName _char() {
    return PrimitiveTypeName.CHAR;
  }

  public static PrimitiveTypeName _float() {
    return PrimitiveTypeName.FLOAT;
  }

  public static PrimitiveTypeName _double() {
    return PrimitiveTypeName.DOUBLE;
  }

  // statements

  public static AssertStatement _assert(ExpressionCode expression) {
    return AssertStatement._assert(expression);
  }

  public static AssertStatement _assert(ExpressionCode expression, ExpressionCode detailMessage) {
    return AssertStatement._assert(expression, detailMessage);
  }

  public static BreakStatement _break() {
    return BreakStatement._break();
  }

  public static BreakStatement _break(Identifier id) {
    return BreakStatement._break(id);
  }

  public static BreakStatement _break(String id) {
    return BreakStatement._break(id);
  }

  public static CaseSwitchElement _case(int value) {
    return CaseSwitchElement._case(value);
  }

  public static CaseSwitchElement _case(Identifier value) {
    return CaseSwitchElement._case(value);
  }

  public static CaseSwitchElement _case(String value) {
    return CaseSwitchElement._case(value);
  }

  public static ContinueStatement _continue() {
    return ContinueStatement._continue();
  }

  public static ContinueStatement _continue(Identifier id) {
    return ContinueStatement._continue(id);
  }

  public static ContinueStatement _continue(String id) {
    return ContinueStatement._continue(id);
  }

  public static DefaultSwitchElement _default() {
    return DefaultSwitchElement._default();
  }

  public static DoStatement.Builder _do(BlockElement... elements) {
    return DoStatement._do(elements);
  }

  public static EnhancedForStatement.Builder _for(Class<?> type, Identifier id,
      ExpressionCode expression) {
    return ForStatement._for(type, id, expression);
  }

  public static EnhancedForStatement.Builder _for(TypeName typeName, Identifier id,
      ExpressionCode expression) {
    return ForStatement._for(typeName, id, expression);
  }

  public static BasicForStatement.Builder _for(
      ForInit init, ExpressionCode expression, StatementExpression update) {
    return ForStatement._for(init, expression, update);
  }

  public static IfThenStatement.Builder _if(ExpressionCode condition) {
    return IfStatement._if(condition);
  }

  public static ReturnStatement _return(String id) {
    return ReturnStatement._return(id);
  }

  public static ReturnStatement _return(ExpressionCode expression) {
    return ReturnStatement._return(expression);
  }

  public static SwitchStatement.Builder _switch(ExpressionCode expression) {
    return SwitchStatement._switch(expression);
  }

  public static SynchronizedStatement.Builder _synchronized(ExpressionCode expression) {
    return SynchronizedStatement._synchronized(expression);
  }

  public static ThrowStatement _throw(ThrowableExpression expression) {
    return ThrowStatement._throw(expression);
  }

  public static TryWithStatement.Builder _try(Resource resource) {
    return TryStatement._try(resource);
  }

  public static TrySimpleElement _try(Statement... statements) {
    return TryStatement._try(statements);
  }

  public static WhileStatement.Builder _while(ExpressionCode expression) {
    return WhileStatement._while(expression);
  }

  public static Block block(BlockStatement... statements) {
    return Block.of(statements);
  }

  public static Resource resource(Class<?> type, Identifier id, VariableInitializer init) {
    return Resource.of(type, id, init);
  }

  public static SimpleLocalVariableDeclaration _var(Class<?> type, Identifier id) {
    return LocalVariableDeclarationStatement._var(type, id);
  }

  public static SimpleLocalVariableDeclaration _var(Class<?> type, String name) {
    return LocalVariableDeclarationStatement._var(type, name);
  }

  public static WithInitLocalVariableDeclaration _var(Class<?> type, Identifier id,
      VariableInitializer init) {
    return LocalVariableDeclarationStatement._var(type, id, init);
  }

  public static WithInitLocalVariableDeclaration _var(Class<?> type, String name,
      VariableInitializer init) {
    return LocalVariableDeclarationStatement._var(type, name, init);
  }

  public static SimpleLocalVariableDeclaration _var(TypeName typeName, Identifier id) {
    return LocalVariableDeclarationStatement._var(typeName, id);
  }

  public static SimpleLocalVariableDeclaration _var(TypeName typeName, String name) {
    return LocalVariableDeclarationStatement._var(typeName, name);
  }

  public static WithInitLocalVariableDeclaration _var(
      TypeName typeName, Identifier id, VariableInitializer init) {
    return LocalVariableDeclarationStatement._var(typeName, id, init);
  }

  public static WithInitLocalVariableDeclaration _var(
      TypeName typeName, String name, VariableInitializer init) {
    return LocalVariableDeclarationStatement._var(typeName, name, init);
  }

}