/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.declaration;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.comuns.collections.GrowableSet;
import br.com.objectos.comuns.collections.ImmutableSet;
import javax.lang.model.element.Modifier;

abstract class ElementModifier extends AbstractCodeElement {

  private final ImmutableSet<Modifier> values;

  ElementModifier(Builder<?> builder) {
    values = builder.values();
  }

  ElementModifier(ImmutableSet<Modifier> values) {
    this.values = values;
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    return w.writeModifierSet(values);
  }

  static abstract class Builder<E extends ElementModifier> {

    private final GrowableSet<Modifier> values = GrowableSet.newSet();

    Builder() {}

    public abstract E build();

    final ImmutableSet<Modifier> values() {
      return values.toImmutableSet();
    }

    final void withModifier(Modifier modifier) {
      values.add(modifier);
    }

    final Builder<E> withModifier(ElementModifier modifier) {
      checkNotNull(modifier, "modifier == null");
      values.addAll(modifier.values);
      return this;
    }

  }

}