/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.element;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.CodeJava;
import br.com.objectos.code.java.expression.Identifier;
import br.com.objectos.code.java.expression.PrimaryNoNewArray;
import br.com.objectos.code.java.statement.BreakStatement;
import br.com.objectos.code.java.statement.ContinueStatement;

public interface Keyword extends CodeElement {

  BreakKeyword BREAK = KeywordImpl.named("break");
  ContinueKeyword CONTINUE = KeywordImpl.named("continue");
  Keyword RETURN = KeywordImpl.named("return");
  ThisKeyword THIS = KeywordImpl.named("this");
  Keyword THROW = KeywordImpl.named("throw");

  interface BreakKeyword extends Keyword, BreakStatement {}

  interface ContinueKeyword extends Keyword, ContinueStatement {}

  interface ThisKeyword extends Keyword, PrimaryNoNewArray {

    static ThisKeyword _this() {
      return Keyword.THIS;
    }

    static Identifier _this(String name) {
      checkNotNull(name, "name == null");
      return CodeJava.id("this." + name);
    }

  }

}