/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.element;

import br.com.objectos.code.java.declaration.ClassBodyElement;
import br.com.objectos.code.java.declaration.InterfaceBodyElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.io.NewLineFormatting.NewLineFormattingAction;
import br.com.objectos.code.java.statement.Block.Semicolon;
import br.com.objectos.code.java.statement.BlockElement;
import br.com.objectos.code.java.statement.StatementOrBlockBuilder;

public abstract class NewLine extends AbstractCodeElement
    implements BlockElement, ClassBodyElement, InterfaceBodyElement {

  private static final NextLine NEXT_LINE = new NextLine();
  private static final Single SINGLE = new Single();

  NewLine() {}

  public static CodeElement nextLine() {
    return NEXT_LINE;
  }

  public static NewLine single() {
    return SINGLE;
  }

  @Override
  public final void acceptNewLineFormattingAction(NewLineFormattingAction action) {
    action.consumeNewLine(this);
  }

  @Override
  public final void acceptSemicolon(Semicolon semicolon) {
    // noop
  }

  @Override
  public final void acceptStatementOrBlockBuilder(StatementOrBlockBuilder builder) {
    builder.nl();
  }

  @Override
  public final boolean equals(Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof NewLine)) {
      return false;
    }
    NewLine that = (NewLine) obj;
    return getClass().equals(that.getClass());
  }

  @Override
  public abstract int hashCode();

  @Override
  public final Kind kind() {
    return Kind.NEW_LINE;
  }

  private static class NextLine extends AbstractCodeElement {
    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
      return w.nextLine();
    }
  }

  private static class Single extends NewLine {
    private Single() {}

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
      // this assumes (correctly?) that this will be only used
      // as a ClassBodyElement inside a w.writeClassBody()
      return w;
    }

    @Override
    public final int hashCode() {
      return 0;
    }
  }

}