/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractForwardingCodeElement;
import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;
import br.com.objectos.comuns.collections.ImmutableList;

final class Arguments extends AbstractForwardingCodeElement {

  private static final Arguments EMPTY = new Arguments(
      ImmutableCodeElement.builder()
          .withOpenParens()
          .withSpaceOff()
          .withCloseParens()
          .build()
  );

  private Arguments(ImmutableCodeElement delegate) {
    super(delegate);
  }

  public static Arguments empty() {
    return EMPTY;
  }

  public static Arguments of(CodeElement... args) {
    ImmutableList<CodeElement> arguments = ImmutableList.newListWithAll(args);
    return of(arguments);
  }

  public static Arguments of(Iterable<? extends CodeElement> args) {
    return new Arguments(
        ImmutableCodeElement.builder()
            .withOpenParens()
            .withSpaceOff()
            .withCommaSeparated(args)
            .withSpaceOff()
            .withCloseParens()
            .build()
    );
  }

}