/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractDefaultCodeElement;
import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;
import br.com.objectos.comuns.collections.StreamIterable;
import java.util.Arrays;
import java.util.function.Function;

final class ArrayAccessImpl extends AbstractDefaultCodeElement
    implements ArrayAccess {

  private static final Function<ExpressionCode, CodeElement> TO_ACCESS0
      = new Function<ExpressionCode, CodeElement>() {
        @Override
        public final CodeElement apply(ExpressionCode t) {
          return access0(t);
        }
      };

  private ArrayAccessImpl(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static ArrayAccess arrayAccess0(ArrayReferenceExpression ref,
      ExpressionCode... expressions) {
    return arrayAccess0(ref, Arrays.asList(expressions));
  }

  static ArrayAccess arrayAccess0(
      ArrayReferenceExpression ref, Iterable<? extends ExpressionCode> expressions) {
    return new ArrayAccessImpl(
        ImmutableCodeElement.builder()
            .withCodeElement(ref)
            .withCodeElements(
                StreamIterable.adapt(expressions).map(TO_ACCESS0)
            )
            .build()
    );
  }

  private static CodeElement access0(ExpressionCode expression) {
    return ImmutableCodeElement.builder()
        .withSpaceOff()
        .withOpenBracket()
        .withSpaceOff()
        .withCodeElement(expression)
        .withSpaceOff()
        .withCloseBracket()
        .build();
  }

  @Override
  public final FieldAccess id(Identifier id) {
    return Expressions.fieldAccess(this, id);
  }

  @Override
  public final FieldAccess id(String id) {
    return Expressions.fieldAccess(this, id);
  }

  @Override
  protected final ArrayReferenceExpression selfArrayReferenceExpression() {
    return this;
  }

  @Override
  protected final Callee selfCallee() {
    return this;
  }

  @Override
  protected final ConditionalAndExpression selfConditionalAndExpression() {
    return this;
  }

  @Override
  protected final LeftHandSide selfLeftHandSide() {
    return this;
  }

  @Override
  protected final MultiplicativeExpression selfMultiplicativeExpression() {
    return this;
  }

  @Override
  protected final MethodReferenceReferenceExpression selfMethodReferenceReferenceExpression() {
    return this;
  }

  @Override
  protected final PostfixExpression selfPostfixExpression() {
    return this;
  }

  @Override
  protected final RelationalExpression selfRelationalExpression() {
    return this;
  }

}
