/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.ImmutableCodeElement;
import br.com.objectos.code.java.type.ClassName;

final class ClassInstanceCreationExpressionImpl
    extends AbstractDefaultStatementExpression
    implements ClassInstanceCreationExpression {

  private ClassInstanceCreationExpressionImpl(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static ClassInstanceCreationExpression new0(
      ClassName className) {
    return new1(className, Arguments.empty());
  }

  static ClassInstanceCreationExpression new0(
      ClassName className, Argument... args) {
    return new1(className, Arguments.of(args));
  }

  static ClassInstanceCreationExpression new0(
      ClassName className, Iterable<? extends Argument> args) {
    return new1(className, Arguments.of(args));
  }

  private static ClassInstanceCreationExpression new1(
      ClassName className, Arguments args) {
    return new ClassInstanceCreationExpressionImpl(
        ImmutableCodeElement.builder()
            .withWord("new")
            .withTypeName(className)
            .withSpaceOff()
            .withCodeElement(args)
            .build()
    );
  }

  static ClassInstanceCreationExpression new0(
      ClassName className, TypeWitness witness) {
    return new1(className, witness, Arguments.empty());
  }

  static ClassInstanceCreationExpression new0(
      ClassName className, TypeWitness witness, Argument... args) {
    return new1(className, witness, Arguments.of(args));
  }

  static ClassInstanceCreationExpression new0(
      ClassName className, TypeWitness witness, Iterable<? extends Argument> args) {
    return new1(className, witness, Arguments.of(args));
  }

  private static ClassInstanceCreationExpression new1(
      ClassName className, TypeWitness witness, Arguments args) {
    return new ClassInstanceCreationExpressionImpl(
        ImmutableCodeElement.builder()
            .withWord("new")
            .withTypeName(className)
            .withSpaceOff()
            .withCodeElement(witness)
            .withSpaceOff()
            .withCodeElement(args)
            .build()
    );
  }

  @Override
  public final FieldAccess id(Identifier id) {
    return Expressions.fieldAccess(this, id);
  }

  @Override
  public final FieldAccess id(String id) {
    return Expressions.fieldAccess(this, id);
  }

  @Override
  protected final ArrayReferenceExpression selfArrayReferenceExpression() {
    throw newUoe(ClassInstanceCreationExpression.class);
  }

  @Override
  protected final Callee selfCallee() {
    return this;
  }

  @Override
  protected final ConditionalAndExpression selfConditionalAndExpression() {
    return this;
  }

  @Override
  protected final LeftHandSide selfLeftHandSide() {
    throw newUoe(ClassInstanceCreationExpression.class);
  }

  @Override
  protected final MethodReferenceReferenceExpression selfMethodReferenceReferenceExpression() {
    return this;
  }

  @Override
  protected final MultiplicativeExpression selfMultiplicativeExpression() {
    return this;
  }

  @Override
  protected final PostfixExpression selfPostfixExpression() {
    return this;
  }

  @Override
  protected final RelationalExpression selfRelationalExpression() {
    return this;
  }

}
