/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractDefaultCodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;

final class ShiftExpressionImpl
    extends AbstractDefaultCodeElement
    implements ShiftExpression {

  private ShiftExpressionImpl(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static ShiftExpression leftShift0(ShiftExpression lhs, AdditiveExpression rhs) {
    return ofOperator("<<", lhs, rhs);
  }

  static ShiftExpression rightShift0(ShiftExpression lhs, AdditiveExpression rhs) {
    return ofOperator(">>", lhs, rhs);
  }

  static ShiftExpression unsignedRightShift0(ShiftExpression lhs, AdditiveExpression rhs) {
    return ofOperator(">>>", lhs, rhs);
  }

  private static ShiftExpression ofOperator(
      String operator, ShiftExpression lhs, AdditiveExpression rhs) {
    return new ShiftExpressionImpl(
        ImmutableCodeElement.builder()
            .withCodeElement(lhs)
            .withWord(operator)
            .withCodeElement(rhs)
            .build()
    );
  }

  @Override
  protected final ArrayReferenceExpression selfArrayReferenceExpression() {
    throw newUoe(ShiftExpression.class);
  }

  @Override
  protected final Callee selfCallee() {
    throw newUoe(ShiftExpression.class);
  }

  @Override
  protected final ConditionalAndExpression selfConditionalAndExpression() {
    return this;
  }

  @Override
  protected final LeftHandSide selfLeftHandSide() {
    throw newUoe(ShiftExpression.class);
  }

  @Override
  protected final MethodReferenceReferenceExpression selfMethodReferenceReferenceExpression() {
    throw newUoe(ShiftExpression.class);
  }

  @Override
  protected final MultiplicativeExpression selfMultiplicativeExpression() {
    throw newUoe(ShiftExpression.class);
  }

  @Override
  protected final PostfixExpression selfPostfixExpression() {
    throw newUoe(ShiftExpression.class);
  }

  @Override
  protected final RelationalExpression selfRelationalExpression() {
    return this;
  }

  @Override
  protected final ShiftExpression selfShiftExpression() {
    return this;
  }

}
