/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.io;

public enum Section {

  BLOCK(1),

  TYPE(2),

  ARRAY_LITERAL(2),

  STATEMENT(0, 2),

  RESOURCE(2);

  final int indentation;
  final int indentationOnNextLine;

  private Section(int indentation) {
    this.indentation = indentation;
    this.indentationOnNextLine = indentation;
  }

  private Section(int indentation, int indentationOnNextLine) {
    this.indentation = indentation;
    this.indentationOnNextLine = indentationOnNextLine;
  }

}