/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.expression.ExpressionCode;
import br.com.objectos.code.java.io.CodeWriter;

abstract class AbstractControlStatement extends AbstractStatement {

  private final ExpressionCode expression;
  private final Block block;

  AbstractControlStatement(ExpressionCode expression, Block block) {
    this.expression = expression;
    this.block = block;
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    return w.writeControl(keyword(), expression).writeCodeElement(block);
  }

  abstract String keyword();

  static abstract class AbstractBuilder<T extends AbstractControlStatement> {

    private final ExpressionCode expression;

    AbstractBuilder(ExpressionCode expression) {
      this.expression = expression;
    }

    public final T block(BlockElement... elements) {
      Block block = Block.of(elements);
      return bodyImpl(expression, block);
    }

    abstract T bodyImpl(ExpressionCode expression, Block block);

  }

}
