/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.expression.ExpressionCode;
import br.com.objectos.code.java.expression.Identifier;
import br.com.objectos.code.java.expression.StatementExpression;
import br.com.objectos.code.java.type.TypeName;

public interface ForStatement extends Statement {

  static EnhancedForStatement.Builder _for(Class<?> type, Identifier id,
      ExpressionCode expression) {
    return EnhancedForStatement.builder(type, id, expression);
  }

  static EnhancedForStatement.Builder _for(TypeName typeName, Identifier id,
      ExpressionCode expression) {
    return EnhancedForStatement.builder(typeName, id, expression);
  }

  static BasicForStatement.Builder _for(
      ForInit init, ExpressionCode expression, StatementExpression update) {
    return BasicForStatement.builder(init, expression, update);
  }

}