/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.element.NewLine;
import br.com.objectos.comuns.collections.GrowableList;

public class StatementOrBlockBuilder {

  private final GrowableList<BlockElement> blockElements = GrowableList.newList();

  private int blockStatementCount;
  private int statementCount;
  private boolean forceBlock;

  private Statement lastStatement;

  StatementOrBlockBuilder() {}

  final CodeElement build() {
    if (!forceBlock && statementCount == 1 && blockStatementCount == 0) {
      return buildStatement();
    } else {
      return buildBlock();
    }
  }

  final void forceBlock() {
    forceBlock = true;
  }

  public final StatementOrBlockBuilder nl() {
    blockElements.add(NewLine.single());
    return this;
  }

  public final StatementOrBlockBuilder withStatement(BlockStatement statement) {
    blockElements.add(statement);
    blockStatementCount++;
    return this;
  }

  final StatementOrBlockBuilder withStatement(Statement statement) {
    blockElements.add(statement);
    lastStatement = statement;
    statementCount++;
    return this;
  }

  private CodeElement buildBlock() {
    return Block.of(blockElements);
  }

  private CodeElement buildStatement() {
    if (blockElements.size() == 1) {
      return lastStatement;
    } else {
      return FormattedStatement.of(blockElements);
    }
  }

}