/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.io.Section;
import br.com.objectos.comuns.collections.ImmutableList;

final class SwitchGroup extends AbstractCodeElement implements SwitchElement {

  private final SwitchElement caseElement;
  private final ImmutableList<BlockStatement> body;

  private SwitchGroup(SwitchElement caseElement, ImmutableList<BlockStatement> body) {
    this.caseElement = caseElement;
    this.body = body;
  }

  static SwitchElement of(CaseSwitchElement caseElement, BlockStatement... statements) {
    return of0(caseElement, statements);
  }

  static SwitchGroup of(DefaultSwitchElement caseElement, BlockStatement... statements) {
    return of0(caseElement, statements);
  }

  private static SwitchGroup of0(SwitchElement caseElement, BlockStatement... statements) {
    ImmutableList<BlockStatement> body = ImmutableList.newListWithAll(statements);
    return new SwitchGroup(caseElement, body);
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    w.writeCodeElement(caseElement);
    w.beginSection(Section.BLOCK);

    for (BlockStatement element : body) {
      w.nextLine();
      w.writeCodeElement(element);
      w.spaceOff();
      w.write(';');
    }

    return w.endSection();
  }

}
