/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.type;

import br.com.objectos.code.java.expression.CastExpression;
import br.com.objectos.code.java.expression.MethodReference;
import br.com.objectos.code.java.expression.TypeWitness;
import br.com.objectos.code.java.expression.UnaryExpressionNotPlusMinus;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.io.JavaFileImportSet;

public class NoTypeName implements ClassNameOrParameterizedTypeName {

  static final NoTypeName VOID = new NoTypeName();

  private NoTypeName() {}

  public static NoTypeName _void() {
    return VOID;
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    return w.writeTypeNameAsWord(this);
  }

  @Override
  public final String acceptJavaFileImportSet(JavaFileImportSet set) {
    return toString();
  }

  @Override
  public final <R, P> R acceptTypeNameVisitor(TypeNameVisitor<R, P> visitor, P p) {
    return visitor.visitNoTypeName(this, p);
  }

  @Override
  public final TypeName arrayCreationTypeName() {
    throw new UnsupportedOperationException();
  }

  @Override
  public final CastExpression cast(UnaryExpressionNotPlusMinus expression) {
    throw new UnsupportedOperationException();
  }

  @Override
  public final boolean isVoid() {
    return true;
  }

  @Override
  public final MethodReference ref(String methodName) {
    throw new UnsupportedOperationException();
  }

  @Override
  public final MethodReference ref(TypeWitness witness, String methodName) {
    throw new UnsupportedOperationException();
  }

  @Override
  public final String toString() {
    return "void";
  }

  @Override
  public final ParameterizedTypeName withTypeArgument(TypeName type) {
    throw new UnsupportedOperationException();
  }

}