/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.type;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.io.JavaFileImportSet;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;

public interface TypeName {

  static TypeName of(TypeMirror type) {
    checkNotNull(type, "type == null");
    return ofUnchecked(type);
  }

  static TypeName ofUnchecked(TypeMirror type) {
    return TypeNameFactory.ofUnchecked(type);
  }

  /*
   * Returns either a simple string representation or the full (qualified) one.
   * 
   * If this type name or any of its components can be imported then this method
   * should return its simple String representation.
   * 
   * Note: this method, though public, is for internal use only as
   * JavaFileImportSet has package private access level.
   */
  String acceptJavaFileImportSet(JavaFileImportSet set);

  <R, P> R acceptTypeNameVisitor(TypeNameVisitor<R, P> visitor, P p);

  TypeName arrayCreationTypeName();

  default boolean isJavaLangObject() {
    return false;
  }

  default boolean isVoid() {
    return false;
  }

  default Optional<ClassName> toClassName() {
    return Optional.empty();
  }

  default ClassName toClassNameUnchecked() {
    throw new UnsupportedOperationException(getClass() + " is not a ClassName instance.");
  }

}