/*
 * This file is part of the objectos :: code :: java project.
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package br.com.objectos.code.java.type;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.expression.CastExpression;
import br.com.objectos.code.java.expression.Expressions;
import br.com.objectos.code.java.expression.MethodReference;
import br.com.objectos.code.java.expression.TypeWitness;
import br.com.objectos.code.java.expression.UnaryExpressionNotPlusMinus;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.io.JavaFileImportSet;
import javax.lang.model.element.TypeParameterElement;

public class TypeVariableName implements ReferenceTypeName {

  private final String name;

  private TypeVariableName(String name) {
    this.name = name;
  }

  public static TypeVariableName named(String name) {
    checkNotNull(name, "name == null");
    return new TypeVariableName(name);
  }

  public static TypeVariableName of(TypeParameterElement element) {
    checkNotNull(element, "element == null");
    return new TypeVariableName(element.getSimpleName().toString());
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    return w.writeTypeNameAsWord(this);
  }

  @Override
  public final String acceptJavaFileImportSet(JavaFileImportSet set) {
    throw new UnsupportedOperationException("Implement me");
  }

  @Override
  public final <R, P> R acceptTypeNameVisitor(TypeNameVisitor<R, P> visitor, P p) {
    return visitor.visitTypeVariableName(this, p);
  }

  @Override
  public final TypeName arrayCreationTypeName() {
    return ClassName.object();
  }

  @Override
  public final CastExpression cast(UnaryExpressionNotPlusMinus expression) {
    return Expressions.cast(this, expression);
  }

  @Override
  public final MethodReference ref(String methodName) {
    return Expressions.ref(this, methodName);
  }

  @Override
  public final MethodReference ref(TypeWitness witness, String methodName) {
    return Expressions.ref(this, witness, methodName);
  }

  public final ArrayTypeName toArrayTypeName() {
    return ArrayTypeName.ofUnchecked(this);
  }

  @Override
  public final String toString() {
    return name;
  }

}