/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.declaration;

import br.com.objectos.code.java.declaration.AnnotationMember;
import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.comuns.collections.GrowableList;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.lang.Preconditions;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;

public class AnnotatedCode
extends AbstractCodeElement {
    private final ClassName qualifiedName;
    private final ImmutableList<AnnotationMember> memberList;

    private AnnotatedCode(Builder builder) {
        this.qualifiedName = builder.qualifiedName;
        this.memberList = builder.memberList();
    }

    public static AnnotatedCode annotatedWith(Class<? extends Annotation> annotationType) {
        return AnnotatedCode.builder(annotationType).build();
    }

    public static AnnotatedCode annotatedWith(ClassName className) {
        Preconditions.checkNotNull((Object)className, (String)"className == null");
        return AnnotatedCode.builder(className).build();
    }

    public static Builder builder(Class<? extends Annotation> annotationType) {
        Preconditions.checkNotNull(annotationType, (String)"annotationType == null");
        return new Builder(ClassName.ofUnchecked(annotationType));
    }

    public static Builder builder(ClassName className) {
        Preconditions.checkNotNull((Object)className, (String)"className == null");
        return new Builder(className);
    }

    public static AnnotatedCode of(Class<? extends Annotation> annotationType) {
        return AnnotatedCode.builder(annotationType).build();
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        switch (this.memberList.size()) {
            case 0: {
                return this.acceptJavaWriter0(w);
            }
            case 1: {
                return this.acceptJavaWriter1(w);
            }
        }
        return this.acceptJavaWriter9(w);
    }

    private CodeWriter acceptJavaWriter0(CodeWriter w) {
        return w.writeAnnotation(this.qualifiedName);
    }

    private CodeWriter acceptJavaWriter1(CodeWriter w) {
        return w.writeAnnotation(this.qualifiedName).write('(').spaceOff().writeCodeElement((CodeElement)this.memberList.get(0)).write(')').spaceOn();
    }

    private CodeWriter acceptJavaWriter9(CodeWriter w) {
        return w.writeAnnotation(this.qualifiedName);
    }

    public static class Builder {
        final ClassName qualifiedName;
        private final Map<String, AnnotationMember.AnnotatedMemberBuilder> memberMap = new LinkedHashMap<String, AnnotationMember.AnnotatedMemberBuilder>();

        private Builder(ClassName qualifiedName) {
            this.qualifiedName = qualifiedName;
        }

        public final Builder addMember(String name, Class<?> type) {
            return this.addMember(name, ClassName.of(type));
        }

        public final Builder addMember(String name, ClassName qualifiedName) {
            this.member(name).addClass(qualifiedName);
            return this;
        }

        public final Builder addMember(String name, String value) {
            this.member(name).addString(value);
            return this;
        }

        public final AnnotatedCode build() {
            return new AnnotatedCode(this);
        }

        final ImmutableList<AnnotationMember> memberList() {
            GrowableList memberList = GrowableList.newList();
            for (AnnotationMember.AnnotatedMemberBuilder builder : this.memberMap.values()) {
                AnnotationMember member = builder.build();
                memberList.add((Object)member);
            }
            return memberList.toImmutableList();
        }

        private AnnotationMember.AnnotatedMemberBuilder member(String name) {
            Preconditions.checkNotNull((Object)name, (String)"name == null");
            return this.memberMap.computeIfAbsent(name, AnnotationMember.AnnotatedMemberBuilder::new);
        }
    }
}

