/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractDefaultCodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;
import br.com.objectos.code.java.expression.ArrayReferenceExpression;
import br.com.objectos.code.java.expression.Callee;
import br.com.objectos.code.java.expression.ConditionalAndExpression;
import br.com.objectos.code.java.expression.Expressions;
import br.com.objectos.code.java.expression.FieldAccess;
import br.com.objectos.code.java.expression.FieldAccessReferenceExpression;
import br.com.objectos.code.java.expression.Identifier;
import br.com.objectos.code.java.expression.LeftHandSide;
import br.com.objectos.code.java.expression.Literal;
import br.com.objectos.code.java.expression.MethodReferenceReferenceExpression;
import br.com.objectos.code.java.expression.MultiplicativeExpression;
import br.com.objectos.code.java.expression.PostfixExpression;
import br.com.objectos.code.java.expression.RelationalExpression;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.comuns.lang.Strings;

final class LiteralImpl
extends AbstractDefaultCodeElement
implements Literal {
    private LiteralImpl(ImmutableCodeElement delegate) {
        super(delegate);
    }

    static Literal l0(boolean value) {
        return LiteralImpl.ofPrimitive(Boolean.toString(value));
    }

    static Literal l0(char value) {
        return LiteralImpl.ofPrimitive("'" + Strings.escapeJava((String)Character.toString(value)) + "'");
    }

    static Literal l0(double value) {
        return LiteralImpl.ofPrimitive(Double.toString(value));
    }

    static Literal l0(int value) {
        return LiteralImpl.ofPrimitive(Integer.toString(value));
    }

    static Literal l0(float value) {
        return LiteralImpl.ofPrimitive(Float.toString(value) + "F");
    }

    static Literal l0(long value) {
        return LiteralImpl.ofPrimitive(Long.toString(value) + "L");
    }

    static Literal l0(Class<?> type) {
        return LiteralImpl.l0(ClassName.of(type));
    }

    static Literal l0(ClassName className) {
        return new LiteralImpl(ImmutableCodeElement.builder().withTypeName(className).withSpaceOff().withWord(".class").build());
    }

    static Literal l0(String s) {
        return new LiteralImpl(ImmutableCodeElement.builder().withStringLiteral(s).build());
    }

    private static Literal ofPrimitive(String value) {
        return new LiteralImpl(ImmutableCodeElement.builder().withWord(value).build());
    }

    @Override
    public final FieldAccess id(Identifier id) {
        return Expressions.fieldAccess((FieldAccessReferenceExpression)this, id);
    }

    @Override
    public final FieldAccess id(String id) {
        return Expressions.fieldAccess((FieldAccessReferenceExpression)this, id);
    }

    @Override
    protected final ArrayReferenceExpression selfArrayReferenceExpression() {
        throw this.newUoe(Literal.class);
    }

    @Override
    protected final Callee selfCallee() {
        return this;
    }

    @Override
    protected final ConditionalAndExpression selfConditionalAndExpression() {
        return this;
    }

    @Override
    protected final LeftHandSide selfLeftHandSide() {
        throw this.newUoe(Literal.class);
    }

    @Override
    protected final MethodReferenceReferenceExpression selfMethodReferenceReferenceExpression() {
        return this;
    }

    @Override
    protected final MultiplicativeExpression selfMultiplicativeExpression() {
        return this;
    }

    @Override
    protected final PostfixExpression selfPostfixExpression() {
        return this;
    }

    @Override
    protected final RelationalExpression selfRelationalExpression() {
        return this;
    }
}

