/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.type;

import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.ClassNameOrParameterizedTypeName;
import br.com.objectos.code.java.type.PrimitiveTypeName;
import br.com.objectos.code.java.type.TypeName;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;

class TypeNameFactory
extends SimpleTypeVisitor8<TypeName, Void> {
    private static final TypeNameFactory INSTANCE = new TypeNameFactory();

    private TypeNameFactory() {
    }

    static TypeName ofUnchecked(TypeMirror type) {
        return type.accept(INSTANCE, null);
    }

    @Override
    public final TypeName visitDeclared(DeclaredType t, Void p) {
        TypeElement typeElement = (TypeElement)t.asElement();
        ClassNameOrParameterizedTypeName typeName = ClassName.of(typeElement);
        List<? extends TypeMirror> typeArgumentList = t.getTypeArguments();
        for (TypeMirror typeMirror : typeArgumentList) {
            typeName = typeName.withTypeArgument(typeMirror.accept(this, p));
        }
        return typeName;
    }

    @Override
    public final TypeName visitPrimitive(PrimitiveType t, Void p) {
        switch (t.getKind()) {
            case BOOLEAN: {
                return PrimitiveTypeName._boolean();
            }
            case BYTE: {
                return PrimitiveTypeName._byte();
            }
            case SHORT: {
                return PrimitiveTypeName._short();
            }
            case INT: {
                return PrimitiveTypeName._int();
            }
            case LONG: {
                return PrimitiveTypeName._long();
            }
            case CHAR: {
                return PrimitiveTypeName._char();
            }
            case FLOAT: {
                return PrimitiveTypeName._float();
            }
            case DOUBLE: {
                return PrimitiveTypeName._double();
            }
        }
        throw new AssertionError();
    }

    @Override
    protected final TypeName defaultAction(TypeMirror e, Void p) {
        throw new UnsupportedOperationException("Implement me");
    }
}

