/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.declaration;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.type.ClassName;

class AnnotationMember extends AbstractCodeElement {

  private final String name;
  private final AnnotationValue value;

  AnnotationMember(AnnotatedMemberBuilder builder) {
    name = builder.name;
    value = builder.value;
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    if (name.equals("value")) {
      return acceptJavaWriter0(w);
    } else {
      throw new UnsupportedOperationException("Implement me");
    }
  }

  private CodeWriter acceptJavaWriter0(CodeWriter w) {
    return w.writeCodeElement(value);
  }

  static class AnnotatedMemberBuilder {

    final String name;
    AnnotationValue value = AnnotationValue.empty();

    AnnotatedMemberBuilder(String name) {
      this.name = name;
    }

    public final void addClass(ClassName type) {
      checkNotNull(type);
      value = value.addClass(type);
    }

    public final void addString(String string) {
      checkNotNull(string);
      value = value.addString(string);
    }

    public final AnnotationMember build() {
      return new AnnotationMember(this);
    }

  }

}