/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.expression.ExpressionCode;
import br.com.objectos.code.java.expression.Identifier;
import br.com.objectos.code.java.expression.StatementExpression;
import br.com.objectos.code.java.type.TypeName;

public interface ForStatement extends Statement {

  static EnhancedForStatement.Builder _for(Class<?> type, Identifier id,
      ExpressionCode expression) {
    return EnhancedForStatement.builder(type, id, expression);
  }

  static EnhancedForStatement.Builder _for(TypeName typeName, Identifier id,
      ExpressionCode expression) {
    return EnhancedForStatement.builder(typeName, id, expression);
  }

  static BasicForStatement.Builder _for(
      ForInit init, ExpressionCode expression, StatementExpression update) {
    return BasicForStatement.builder(init, expression, update);
  }

}