/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.io.CodeWriter;

public class IfThenElseStatement extends AbstractStatement {

  private final IfThenStatement ifStatement;
  private final Statement statement;

  IfThenElseStatement(IfThenStatement ifStatement, Statement statement) {
    this.ifStatement = ifStatement;
    this.statement = statement;
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    return w
        .writeCodeElement(ifStatement)
        .writeWord("else")
        .writeCodeElement(statement);
  }

}