/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.element.NewLine;
import br.com.objectos.comuns.collections.GrowableList;

public class StatementOrBlockBuilder {

  private final GrowableList<BlockElement> blockElements = GrowableList.newList();

  private int blockStatementCount;
  private int statementCount;
  private boolean forceBlock;

  private Statement lastStatement;

  StatementOrBlockBuilder() {}

  final CodeElement build() {
    if (!forceBlock && statementCount == 1 && blockStatementCount == 0) {
      return buildStatement();
    } else {
      return buildBlock();
    }
  }

  final void forceBlock() {
    forceBlock = true;
  }

  public final StatementOrBlockBuilder nl() {
    blockElements.add(NewLine.single());
    return this;
  }

  public final StatementOrBlockBuilder withStatement(BlockStatement statement) {
    blockElements.add(statement);
    blockStatementCount++;
    return this;
  }

  final StatementOrBlockBuilder withStatement(Statement statement) {
    blockElements.add(statement);
    lastStatement = statement;
    statementCount++;
    return this;
  }

  private CodeElement buildBlock() {
    return Block.of(blockElements);
  }

  private CodeElement buildStatement() {
    if (blockElements.size() == 1) {
      return lastStatement;
    } else {
      return FormattedStatement.of(blockElements);
    }
  }

}