/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.io.Section;
import br.com.objectos.comuns.collections.ImmutableList;

final class SwitchGroup extends AbstractCodeElement implements SwitchElement {

  private final SwitchElement caseElement;
  private final ImmutableList<BlockStatement> body;

  private SwitchGroup(SwitchElement caseElement, ImmutableList<BlockStatement> body) {
    this.caseElement = caseElement;
    this.body = body;
  }

  static SwitchElement of(CaseSwitchElement caseElement, BlockStatement... statements) {
    return of0(caseElement, statements);
  }

  static SwitchGroup of(DefaultSwitchElement caseElement, BlockStatement... statements) {
    return of0(caseElement, statements);
  }

  private static SwitchGroup of0(SwitchElement caseElement, BlockStatement... statements) {
    ImmutableList<BlockStatement> body = ImmutableList.newListWithAll(statements);
    return new SwitchGroup(caseElement, body);
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    w.writeCodeElement(caseElement);
    w.beginSection(Section.BLOCK);

    for (BlockStatement element : body) {
      w.nextLine();
      w.writeCodeElement(element);
      w.spaceOff();
      w.write(';');
    }

    return w.endSection();
  }

}
