/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.statement;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.expression.ExpressionCode;

public class WhileStatement extends AbstractControlStatement {

  private WhileStatement(ExpressionCode expression, Block block) {
    super(expression, block);
  }

  public static WhileStatement.Builder _while(ExpressionCode expression) {
    return WhileStatement.builder(expression);
  }

  static Builder builder(ExpressionCode expression) {
    checkNotNull(expression, "expression == null");
    return new Builder(expression);
  }

  @Override
  final String keyword() {
    return "while";
  }

  public static class Builder extends AbstractBuilder<WhileStatement> {

    private Builder(ExpressionCode expression) {
      super(expression);
    }

    @Override
    final WhileStatement bodyImpl(
        ExpressionCode expression, Block block) {
      return new WhileStatement(expression, block);
    }

  }

}
