/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.type;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

public class TypeNames {

  private TypeNames() {}

  // ClassName

  public static ClassName cn(Class<?> type) {
    checkNotNull(type, "type == null");
    return ClassName.ofUnchecked(type);
  }

  // WildcardTypeName  
  
  public static WildcardTypeName wildcard() {
    return WildcardTypeName.UNBOUNDED;
  }

  public static WildcardTypeName wildcardExtends(ReferenceTypeName bound) {
    checkNotNull(bound, "bound == null");
    return WildcardTypeName.extendsUnchecked(bound);
  }

  public static WildcardTypeName wildcardSuper(ReferenceTypeName bound) {
    checkNotNull(bound, "bound == null");
    return WildcardTypeName.superUnchecked(bound);
  }

}
