/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.io;

import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.expression.ExpressionCode;
import br.com.objectos.code.java.expression.StatementExpression;
import br.com.objectos.code.java.io.ImportSet;
import br.com.objectos.code.java.io.Indentation;
import br.com.objectos.code.java.io.Section;
import br.com.objectos.code.java.io.Space;
import br.com.objectos.code.java.statement.ForInit;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.ClassNameOrParameterizedTypeName;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.code.java.type.TypeParameterName;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.collections.StreamIterator;
import br.com.objectos.comuns.collections.StreamList;
import br.com.objectos.comuns.lang.Strings;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Locale;
import javax.lang.model.element.Modifier;

public class CodeWriter {
    private static final int INDENTATION_SIZE = 2;
    private final StringBuilder out = new StringBuilder();
    private final ImportSet importSet;
    private final Deque<String> simpleNameStack = new ArrayDeque<String>();
    private int length;
    private Indentation indentation = Indentation.start();
    private Space space = Space.OFF;

    private CodeWriter(ImportSet importSet) {
        this.importSet = importSet;
    }

    public final String toString() {
        return this.out.toString();
    }

    public static CodeWriter forJavaFile(ImportSet importSet) {
        return new CodeWriter(importSet);
    }

    public static CodeWriter forToString() {
        ImportSet importSet = ImportSet.forToString();
        return new CodeWriter(importSet);
    }

    final CodeWriter beginBlock() {
        return this.writeWord('{').beginSection(Section.BLOCK);
    }

    public final CodeWriter beginSection(Section kind) {
        this.indentation = this.indentation.push(kind);
        return this;
    }

    final CodeWriter endBlock() {
        return this.endSection().writePreIndentation().write('}');
    }

    public final CodeWriter endSection() {
        this.indentation = this.indentation.pop();
        return this;
    }

    final CodeWriter join(String separator, Iterator<? extends CodeElement> elements) {
        Space cache = this.space;
        if (elements.hasNext()) {
            this.spaceOff().writeCodeElement(elements.next());
            while (elements.hasNext()) {
                this.write(separator).spaceOff().writeCodeElement(elements.next());
            }
        }
        this.space = cache;
        return this;
    }

    public final CodeWriter nextLine() {
        this.indentation.nextLine();
        return this.write('\n').resetLength().spaceOff();
    }

    public final CodeWriter popSimpleName() {
        this.simpleNameStack.pop();
        return this;
    }

    public final CodeWriter pushSimpleName(String simpleName) {
        this.simpleNameStack.push(simpleName);
        return this;
    }

    final CodeWriter resetLength() {
        this.length = 0;
        return this;
    }

    public final CodeWriter spaceOff() {
        this.space = Space.OFF;
        return this;
    }

    public final CodeWriter spaceOn() {
        this.space = Space.ON;
        return this;
    }

    public final String toJavaFile() {
        StringBuilder out = new StringBuilder();
        out.append(this.importSet);
        if (!this.importSet.isEmpty()) {
            out.append('\n');
            out.append('\n');
        }
        out.append(this.toString());
        return out.toString();
    }

    public final CodeWriter write(char c) {
        this.append(c);
        ++this.length;
        return this;
    }

    public final CodeWriter write(String string) {
        this.append(string);
        this.length += string.length();
        return this;
    }

    public final CodeWriter writeAnnotation(ClassName qualifiedName) {
        return this.writeWord('@').writeTypeName(qualifiedName);
    }

    public final CodeWriter writeAnnotations(Iterable<? extends CodeElement> list) {
        for (CodeElement codeElement : list) {
            this.writeCodeElement(codeElement).nextLine();
        }
        return this;
    }

    public final CodeWriter writeBlock(Iterable<? extends CodeElement> list) {
        return this.beginBlock().block0(list).endBlock();
    }

    public final CodeWriter writeCast(TypeName type) {
        return this.writeWord('(').spaceOff().writeTypeName(type).spaceOff().writeWord(')');
    }

    public final CodeWriter writeCodeElement(CodeElement element) {
        return element.acceptCodeWriter(this);
    }

    public final CodeWriter writeCodeElements(Iterable<? extends CodeElement> elements) {
        for (CodeElement codeElement : elements) {
            codeElement.acceptCodeWriter(this);
        }
        return this;
    }

    public final CodeWriter writeControl(String control, ExpressionCode expression) {
        return this.writeWord(control).writeParenthesized(expression);
    }

    final CodeWriter writeIndentation(int count) {
        for (int i = 0; i < count * 2; ++i) {
            this.write(' ');
        }
        return this;
    }

    public final CodeWriter writeFor(ForInit init, ExpressionCode test, StatementExpression update) {
        this.writeWord("for");
        this.writeWord('(');
        this.spaceOff();
        this.writeCodeElement(init).spaceOff().writeWord(';');
        this.writeCodeElement(test).spaceOff().writeWord(';');
        this.writeCodeElement(update).spaceOff().writeWord(')');
        return this;
    }

    public final CodeWriter writeModifierSet(Iterable<Modifier> set) {
        for (Modifier modifier : set) {
            this.writeWord(modifier.name().toLowerCase(Locale.US));
        }
        return this;
    }

    public final CodeWriter writeImplementsIfNecessary(ImmutableList<ClassNameOrParameterizedTypeName> interfaces) {
        if (interfaces.isEmpty()) {
            return this;
        }
        this.writeWord("implements");
        StreamIterator iterator = interfaces.iterator();
        this.writeTypeNameAsWord((TypeName)iterator.next());
        while (iterator.hasNext()) {
            this.write(", ");
            this.writeTypeName((TypeName)iterator.next());
        }
        return this;
    }

    public final CodeWriter writeParameters(Iterable<? extends CodeElement> parameters) {
        return this.write('(').parameters0(parameters).write(')');
    }

    public final CodeWriter writeParenthesized(CodeElement element) {
        return this.writeWord('(').spaceOff().writeCodeElement(element).spaceOff().writeWord(')');
    }

    public final CodeWriter writePreIndentation() {
        if (this.length == 0) {
            this.writePreIndentation0();
        }
        return this;
    }

    public final CodeWriter writePreSpace() {
        this.space.writeTo(this);
        return this;
    }

    public final CodeWriter writeSimpleName() {
        return this.writeWord(this.peekSimpleName());
    }

    public final CodeWriter writeSimpleNameWith(StreamList<? extends TypeParameterName> typeParameters) {
        if (typeParameters.isEmpty()) {
            return this.writeSimpleName();
        }
        return this.simpleName0(typeParameters);
    }

    public final CodeWriter writeStringLiteral(String string) {
        String escaped = Strings.escapeJava((String)string);
        return this.writeWord('\"').write(escaped).write('\"');
    }

    public final CodeWriter writeTypeName(TypeName typeName) {
        String s = this.importSet.get(typeName);
        return this.write(s);
    }

    public final CodeWriter writeTypeNameAsWord(TypeName typeName) {
        String s = this.importSet.get(typeName);
        return this.writeWord(s);
    }

    public final CodeWriter writeWord(char c) {
        return this.writePreWord().write(c).spaceOn();
    }

    public final CodeWriter writeWord(String word) {
        return this.writePreWord().write(word).spaceOn();
    }

    private void append(char c) {
        this.out.append(c);
    }

    private void append(String string) {
        this.out.append(string);
    }

    private CodeWriter block0(Iterable<? extends CodeElement> list) {
        Iterator<? extends CodeElement> iterator = list.iterator();
        if (iterator.hasNext()) {
            this.nextLine();
            this.writeCodeElement(iterator.next()).nextLine();
            while (iterator.hasNext()) {
                this.writeCodeElement(iterator.next()).nextLine();
            }
        }
        return this;
    }

    private CodeWriter parameters0(Iterable<? extends CodeElement> elements) {
        Iterator<? extends CodeElement> iterator = elements.iterator();
        Space cache = this.space;
        if (iterator.hasNext()) {
            this.spaceOff().writeCodeElement(iterator.next());
            while (iterator.hasNext()) {
                this.write(", ").spaceOff().writeCodeElement(iterator.next());
            }
        }
        this.space = cache;
        return this;
    }

    private String peekSimpleName() {
        if (this.simpleNameStack.isEmpty()) {
            throw new IllegalStateException("Stack of simple names is empty.");
        }
        return this.simpleNameStack.peek();
    }

    private void writePreIndentation0() {
        this.indentation.acceptCodeWriter(this);
    }

    private CodeWriter writePreWord() {
        return this.writePreIndentation().writePreSpace();
    }

    private CodeWriter simpleName0(StreamList<? extends TypeParameterName> list) {
        this.writePreWord().write(this.peekSimpleName()).write('<');
        StreamIterator iterator = list.iterator();
        if (iterator.hasNext()) {
            this.writeCodeElement((CodeElement)iterator.next());
            while (iterator.hasNext()) {
                this.write(", ").writeCodeElement((CodeElement)iterator.next());
            }
        }
        return this.write('>').spaceOn();
    }
}

