/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.io;

import br.com.objectos.code.java.declaration.PackageName;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.io.ImportSet;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.comuns.collections.GrowableSet;
import br.com.objectos.comuns.collections.StreamIterator;

public class JavaFileImportSet
extends ImportSet {
    private final GrowableSet<ClassName> qualifiedNameSet = GrowableSet.newSet();
    private final GrowableSet<String> simpleNameSet = GrowableSet.newSet();
    private final PackageName packageName;

    JavaFileImportSet(PackageName packageName) {
        this.packageName = packageName;
    }

    @Override
    public final boolean contains(ClassName qualifiedName) {
        return this.qualifiedNameSet.contains((Object)qualifiedName);
    }

    @Override
    public final String get(TypeName typeName) {
        return typeName.acceptJavaFileImportSet(this);
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0 && this.packageName.isUnnamed();
    }

    @Override
    public final int size() {
        return this.qualifiedNameSet.size();
    }

    public final String toString() {
        return this.packageName.isUnnamed() ? this.toStringUnnamed() : this.toStringRegular();
    }

    public final boolean addQualifiedName(ClassName qualifiedName) {
        return this.qualifiedNameSet.add((Object)qualifiedName);
    }

    public final boolean addSimpleName(String simpleName) {
        return this.simpleNameSet.add((Object)simpleName);
    }

    public final boolean canSkipImport(PackageName otherPackageName) {
        return otherPackageName.is("java.lang") || this.packageName.equals(otherPackageName);
    }

    private String toStringRegular() {
        CodeWriter w = CodeWriter.forToString();
        w.writeWord("package");
        w.writeWord(this.packageName.toString());
        w.write(';');
        if (!this.qualifiedNameSet.isEmpty()) {
            w.nextLine();
        }
        for (ClassName className : this.qualifiedNameSet.sorted()) {
            w.nextLine();
            this.writeImport(w, className);
        }
        return w.toString();
    }

    private String toStringUnnamed() {
        CodeWriter w = CodeWriter.forToString();
        StreamIterator iterator = this.qualifiedNameSet.sorted().iterator();
        if (iterator.hasNext()) {
            this.writeImport(w, (ClassName)iterator.next());
            while (iterator.hasNext()) {
                w.nextLine();
                this.writeImport(w, (ClassName)iterator.next());
            }
        }
        return w.toString();
    }

    private void writeImport(CodeWriter w, ClassName className) {
        w.writeWord("import");
        w.writeWord(className.toString());
        w.write(';');
    }
}

