/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.expression.ExpressionCode;
import br.com.objectos.code.java.expression.StatementExpression;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.statement.AbstractStatement;
import br.com.objectos.code.java.statement.Block;
import br.com.objectos.code.java.statement.BlockElement;
import br.com.objectos.code.java.statement.ForInit;
import br.com.objectos.code.java.statement.ForStatement;
import br.com.objectos.code.java.statement.Statement;
import br.com.objectos.comuns.lang.Preconditions;

public class BasicForStatement
extends AbstractStatement
implements ForStatement {
    private final ForInit init;
    private final ExpressionCode test;
    private final StatementExpression update;
    private final Statement statement;

    private BasicForStatement(ForInit init, ExpressionCode test, StatementExpression update, Statement statement) {
        this.init = init;
        this.test = test;
        this.update = update;
        this.statement = statement;
    }

    static Builder builder(ForInit init, ExpressionCode test, StatementExpression update) {
        Preconditions.checkNotNull((Object)init, (String)"init == null");
        Preconditions.checkNotNull((Object)test, (String)"test == null");
        Preconditions.checkNotNull((Object)update, (String)"update == null");
        return new Builder(init, test, update);
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        w.writeFor(this.init, this.test, this.update);
        w.writeCodeElement(this.statement);
        return w;
    }

    @Override
    public final void acceptSemicolon(Block.Semicolon semicolon) {
        this.statement.acceptSemicolon(semicolon);
    }

    public static class Builder {
        private final ForInit init;
        private final ExpressionCode test;
        private final StatementExpression update;

        private Builder(ForInit init, ExpressionCode test, StatementExpression update) {
            this.init = init;
            this.test = test;
            this.update = update;
        }

        public final BasicForStatement block(BlockElement ... elements) {
            Block block = Block.of(elements);
            return new BasicForStatement(this.init, this.test, this.update, block);
        }
    }
}

