/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.expression.ExpressionCode;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.statement.AbstractStatement;
import br.com.objectos.code.java.statement.SwitchElement;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.lang.Preconditions;

public class SwitchStatement
extends AbstractStatement {
    private final ExpressionCode expression;
    private final ImmutableList<SwitchElement> body;

    private SwitchStatement(ExpressionCode expression, ImmutableList<SwitchElement> body) {
        this.expression = expression;
        this.body = body;
    }

    public static Builder _switch(ExpressionCode expression) {
        return SwitchStatement.builder(expression);
    }

    static Builder builder(ExpressionCode expression) {
        Preconditions.checkNotNull((Object)expression, (String)"expression == null");
        return new Builder(expression);
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        w.writeWord("switch");
        w.writeWord('(').spaceOff();
        w.writeCodeElement(this.expression);
        w.spaceOff().writeWord(')');
        w.writeBlock((Iterable<? extends CodeElement>)this.body);
        return w;
    }

    public static class Builder {
        private final ExpressionCode expression;

        private Builder(ExpressionCode expression) {
            this.expression = expression;
        }

        public final SwitchStatement block(SwitchElement ... elements) {
            ImmutableList body = ImmutableList.newListWithAll((Object[])elements);
            return new SwitchStatement(this.expression, body);
        }
    }
}

