/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.declaration;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.comuns.collections.GrowableSet;
import br.com.objectos.comuns.collections.ImmutableSet;
import javax.lang.model.element.Modifier;

abstract class ElementModifier extends AbstractCodeElement {

  private final ImmutableSet<Modifier> values;

  ElementModifier(Builder<?> builder) {
    values = builder.values();
  }

  ElementModifier(ImmutableSet<Modifier> values) {
    this.values = values;
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    return w.writeModifierSet(values);
  }

  static abstract class Builder<E extends ElementModifier> {

    private final GrowableSet<Modifier> values = GrowableSet.newSet();

    Builder() {}

    public abstract E build();

    final ImmutableSet<Modifier> values() {
      return values.toImmutableSet();
    }

    final void withModifier(Modifier modifier) {
      values.add(modifier);
    }

    final Builder<E> withModifier(ElementModifier modifier) {
      checkNotNull(modifier, "modifier == null");
      values.addAll(modifier.values);
      return this;
    }

  }

}