/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.declaration;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.type.ClassNameOrParameterizedTypeName;
import br.com.objectos.code.java.type.TypeName;

abstract class Extends extends AbstractCodeElement {

  private static final Extends NONE = new None();

  Extends() {}

  public static Extends ofTypeName(ClassNameOrParameterizedTypeName typeName) {
    return typeName.isVoid() ? none() : single(typeName);
  }

  static Extends none() {
    return NONE;
  }

  static Extends single(TypeName name) {
    return new Single(name);
  }

  private static class None extends Extends {
    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
      return w;
    }
  }

  private static class Single extends Extends {
    private final TypeName name;

    Single(TypeName name) {
      this.name = name;
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
      return w.writeWord("extends").writeTypeNameAsWord(name);
    }
  }

}