/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractDefaultCodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;

final class ShiftExpressionImpl
    extends AbstractDefaultCodeElement
    implements ShiftExpression {

  private ShiftExpressionImpl(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static ShiftExpression leftShift0(ShiftExpression lhs, AdditiveExpression rhs) {
    return ofOperator("<<", lhs, rhs);
  }

  static ShiftExpression rightShift0(ShiftExpression lhs, AdditiveExpression rhs) {
    return ofOperator(">>", lhs, rhs);
  }

  static ShiftExpression unsignedRightShift0(ShiftExpression lhs, AdditiveExpression rhs) {
    return ofOperator(">>>", lhs, rhs);
  }

  private static ShiftExpression ofOperator(
      String operator, ShiftExpression lhs, AdditiveExpression rhs) {
    return new ShiftExpressionImpl(
        ImmutableCodeElement.builder()
            .withCodeElement(lhs)
            .withWord(operator)
            .withCodeElement(rhs)
            .build()
    );
  }

  @Override
  protected final ArrayReferenceExpression selfArrayReferenceExpression() {
    throw newUoe(ShiftExpression.class);
  }

  @Override
  protected final Callee selfCallee() {
    throw newUoe(ShiftExpression.class);
  }

  @Override
  protected final ConditionalAndExpression selfConditionalAndExpression() {
    return this;
  }

  @Override
  protected final LeftHandSide selfLeftHandSide() {
    throw newUoe(ShiftExpression.class);
  }

  @Override
  protected final MethodReferenceReferenceExpression selfMethodReferenceReferenceExpression() {
    throw newUoe(ShiftExpression.class);
  }

  @Override
  protected final MultiplicativeExpression selfMultiplicativeExpression() {
    throw newUoe(ShiftExpression.class);
  }

  @Override
  protected final PostfixExpression selfPostfixExpression() {
    throw newUoe(ShiftExpression.class);
  }

  @Override
  protected final RelationalExpression selfRelationalExpression() {
    return this;
  }

  @Override
  protected final ShiftExpression selfShiftExpression() {
    return this;
  }

}
