/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.statement;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.expression.Identifier;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.comuns.collections.ImmutableList;

abstract class TryElement extends AbstractCodeElement {

  public final TryCatchStatement.Builder _catch(Class<? extends Throwable> type, Identifier id) {
    checkNotNull(type, "type == null");
    checkNotNull(id, "id == null");
    return _catch0(id, toTypeName(type));
  }

  public final TryCatchStatement.Builder _catch(
      Class<? extends Throwable> type1,
      Class<? extends Throwable> type2,
      Identifier id) {
    checkNotNull(type1, "type1 == null");
    checkNotNull(type2, "type2 == null");
    checkNotNull(id, "id == null");
    return _catch0(id, toTypeName(type1), toTypeName(type2));
  }

  private TryCatchStatement.Builder _catch0(Identifier id, TypeName... types) {
    ImmutableList<TypeName> exceptionTypes = ImmutableList.newListWithAll(types);
    return TryCatchStatement.builder(this, exceptionTypes, id);
  }

  private TypeName toTypeName(Class<? extends Throwable> type) {
    return ClassName.of(type);
  }

}
