/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.type.TypeName;

public class WithInitLocalVariableDeclaration extends LocalVariableDeclaration implements Resource {

  private final VariableInitializer init;

  private WithInitLocalVariableDeclaration(TypeName typeName,
                                           String name,
                                           VariableInitializer init) {
    super(typeName, name);
    this.init = init;
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    return w
        .writeTypeNameAsWord(typeName).writeWord(name)
        .writeWord('=')
        .writeCodeElement(init);
  }

  static WithInitLocalVariableDeclaration ofUnchecked(
      TypeName typeName, String name, VariableInitializer init) {
    return new WithInitLocalVariableDeclaration(typeName, name, init);
  }

}