/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.type;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.declaration.PackageName;
import br.com.objectos.comuns.lang.Strings;

public interface EnclosingElement {

  PackageName packageName();

  default ClassName nestedClass(String simpleName) {
    checkNotNull(simpleName);
    return new ClassName(this, simpleName);
  }

  default String toString(String simpleName) {
    String enclosing = toString();
    return Strings.isNullOrEmpty(enclosing)
        ? simpleName
        : enclosing + "." + simpleName;
  }

}