/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.declaration;

import br.com.objectos.code.java.declaration.AnnotatedCode;
import br.com.objectos.code.java.declaration.ClassBodyElement;
import br.com.objectos.code.java.declaration.ClassModifier;
import br.com.objectos.code.java.declaration.Extends;
import br.com.objectos.code.java.declaration.TypeCode;
import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.io.BodyFormatter;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.ClassNameOrParameterizedTypeName;
import br.com.objectos.code.java.type.TypeParameterName;
import br.com.objectos.comuns.collections.GrowableList;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.collections.StreamIterable;
import br.com.objectos.comuns.collections.StreamList;
import br.com.objectos.comuns.lang.Preconditions;
import java.lang.annotation.Annotation;
import javax.lang.model.element.TypeElement;

public class ClassCode
extends TypeCode {
    private final ImmutableList<AnnotatedCode> annotationList;
    private final ClassModifier modifier;
    private final String simpleName;
    private final ImmutableList<TypeParameterName> typeParameters;
    private final Extends _extends;
    private final ImmutableList<ClassNameOrParameterizedTypeName> interfaces;
    private final ImmutableList<ClassBodyElement> bodyElements;

    private ClassCode(Builder builder) {
        this.annotationList = builder.annotationList();
        this.modifier = builder.modifier();
        this.simpleName = builder.simpleName;
        this.typeParameters = builder.typeParameters();
        this._extends = builder._extends;
        this.interfaces = builder.interfaces();
        this.bodyElements = builder.bodyElements();
    }

    public static Builder _class(ClassName className) {
        return ClassCode.builder()._class(className);
    }

    public static Builder _class(String simpleName) {
        return ClassCode.builder()._class(simpleName);
    }

    public static Builder _final() {
        return ClassCode.builder()._final();
    }

    public static Builder _private() {
        return ClassCode.builder()._private();
    }

    public static Builder _public() {
        return ClassCode.builder()._public();
    }

    public static Builder annotatedWith(AnnotatedCode annotation) {
        return ClassCode.builder().annotatedWith(annotation);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        return w.pushSimpleName(this.simpleName).writeAnnotations((Iterable<? extends CodeElement>)this.annotationList).writeCodeElement(this.modifier).writeWord("class").writeSimpleNameWith((StreamList<? extends TypeParameterName>)this.typeParameters).writeCodeElement(this._extends).writeImplementsIfNecessary(this.interfaces).writeBlock((Iterable<? extends CodeElement>)this.bodyElements).popSimpleName();
    }

    @Override
    public final String simpleName() {
        return this.simpleName;
    }

    public static class Builder {
        private final GrowableList<AnnotatedCode> annotatedList = GrowableList.newList();
        private final ClassModifier.Builder modifier = ClassModifier.builder();
        private String simpleName = "Unnamed";
        private final GrowableList<TypeParameterName> typeParameters = GrowableList.newList();
        private Extends _extends = Extends.none();
        private final GrowableList<ClassNameOrParameterizedTypeName> interfaces = GrowableList.newList();
        private final GrowableList<ClassBodyElement> bodyElements = GrowableList.newList();
        private BodyFormatter formatter = BodyFormatter.defaultFormatter();

        private Builder() {
        }

        public final Builder _class(ClassName className) {
            Preconditions.checkNotNull((Object)className, (String)"className == null");
            return this._class(className.simpleName());
        }

        public final Builder _class(String simpleName) {
            this.simpleName = (String)Preconditions.checkNotNull((Object)simpleName, (String)"simpleName == null");
            return this;
        }

        public final Builder _extends(ClassNameOrParameterizedTypeName superclass) {
            Preconditions.checkNotNull((Object)superclass, (String)"superclass == null");
            this._extends = Extends.ofTypeName(superclass);
            return this;
        }

        public final Builder _implements(Iterable<? extends ClassNameOrParameterizedTypeName> ifaces) {
            Preconditions.checkNotNull(ifaces, (String)"ifaces == null");
            this.interfaces.addAll(ifaces);
            return this;
        }

        public final Builder _abstract() {
            this.modifier._abstract();
            return this;
        }

        public final Builder _final() {
            this.modifier._final();
            return this;
        }

        public final Builder _private() {
            this.modifier._private();
            return this;
        }

        public final Builder _public() {
            this.modifier._public();
            return this;
        }

        public final Builder _static() {
            this.modifier._static();
            return this;
        }

        public final Builder annotatedWith(AnnotatedCode annotated) {
            this.annotatedList.add((Object)annotated);
            return this;
        }

        public final Builder annotatedWith(Class<? extends Annotation> annotationType) {
            return this.annotatedWith(AnnotatedCode.annotatedWith(annotationType));
        }

        public final Builder body(ClassBodyElement ... elements) {
            this.bodyElements.fluentAdd((Object[])elements);
            return this;
        }

        public final Builder body(Iterable<? extends ClassBodyElement> elements) {
            return this.withBodyElements(elements);
        }

        public final ClassCode build() {
            return new ClassCode(this);
        }

        public final ClassCode buildWith(BodyFormatter formatter) {
            this.formatter = (BodyFormatter)Preconditions.checkNotNull((Object)formatter, (String)"formatter == null");
            return this.build();
        }

        public final Builder withBodyElement(ClassBodyElement element) {
            this.bodyElements.add((Object)element);
            return this;
        }

        public final Builder withBodyElements(Iterable<? extends ClassBodyElement> elements) {
            this.bodyElements.addAll(elements);
            return this;
        }

        public final Builder withModifier(ClassModifier modifier) {
            this.modifier.withModifier(modifier);
            return this;
        }

        public final Builder withInterface(ClassNameOrParameterizedTypeName iface) {
            this.interfaces.addWithNullMessage((Object)iface, "iface == null");
            return this;
        }

        public final Builder withTypeParameter(String name) {
            return this.withTypeParameter0(TypeParameterName.named(name));
        }

        public final Builder withTypeParameter(TypeParameterName parameter) {
            Preconditions.checkNotNull((Object)parameter, (String)"parameter == null");
            return this.withTypeParameter0(parameter);
        }

        public final Builder withTypeParameters(Iterable<TypeParameterName> parameters) {
            Preconditions.checkNotNull(parameters, (String)"parameters == null");
            return this.withTypeParameters0(parameters);
        }

        public final Builder withTypeParametersFrom(TypeElement type) {
            Preconditions.checkNotNull((Object)type, (String)"type == null");
            StreamIterable<TypeParameterName> parameters = TypeParameterName.streamIterableOf(type);
            return this.withTypeParameters0((Iterable<TypeParameterName>)parameters);
        }

        final ImmutableList<AnnotatedCode> annotationList() {
            return this.annotatedList.toImmutableList();
        }

        final ImmutableList<ClassBodyElement> bodyElements() {
            return this.formatter.format(this.bodyElements, ClassBodyElement.class);
        }

        final ImmutableList<ClassNameOrParameterizedTypeName> interfaces() {
            return this.interfaces.toImmutableList();
        }

        final ClassModifier modifier() {
            return this.modifier.build();
        }

        final ImmutableList<TypeParameterName> typeParameters() {
            return this.typeParameters.toImmutableList();
        }

        private Builder withTypeParameter0(TypeParameterName name) {
            this.typeParameters.add((Object)name);
            return this;
        }

        private Builder withTypeParameters0(Iterable<TypeParameterName> parameters) {
            this.typeParameters.addAll(parameters);
            return this;
        }
    }
}

