/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.declaration;

import br.com.objectos.code.java.declaration.AccessLevel;
import br.com.objectos.code.java.declaration.AnnotatedCode;
import br.com.objectos.code.java.declaration.BodyElement;
import br.com.objectos.code.java.declaration.ClassBodyElement;
import br.com.objectos.code.java.declaration.InterfaceBodyElement;
import br.com.objectos.code.java.declaration.MethodModifier;
import br.com.objectos.code.java.declaration.ParameterCode;
import br.com.objectos.code.java.declaration.ParameterTypeName;
import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.statement.Block;
import br.com.objectos.code.java.statement.BlockStatement;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.NoTypeName;
import br.com.objectos.code.java.type.PrimitiveTypeName;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.comuns.collections.GrowableList;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.lang.Preconditions;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;

public final class MethodCode
extends AbstractCodeElement
implements ClassBodyElement,
InterfaceBodyElement {
    private final MethodModifier modifier;
    private final TypeName typeName;
    private final String name;
    private final ImmutableList<AnnotatedCode> annotations;
    private final ImmutableList<ParameterCode> parameters;
    private final Block block;

    private MethodCode(Builder builder) {
        this.modifier = builder.modifier();
        this.typeName = builder.typeName;
        this.name = builder.name;
        this.annotations = builder.annotations();
        this.parameters = builder.parameters();
        this.block = builder.block();
    }

    public static Builder _public() {
        return MethodCode.builder()._public();
    }

    public static Builder _protected() {
        return MethodCode.builder()._protected();
    }

    public static Builder _private() {
        return MethodCode.builder()._private();
    }

    public static Builder _abstract() {
        return MethodCode.builder()._abstract();
    }

    public static Builder _default() {
        return MethodCode.builder()._default();
    }

    public static Builder _static() {
        return MethodCode.builder()._static();
    }

    public static Builder _final() {
        return MethodCode.builder()._final();
    }

    public static Builder _synchronized() {
        return MethodCode.builder()._synchronized();
    }

    public static Builder _native() {
        return MethodCode.builder()._native();
    }

    public static Builder _strictfp() {
        return MethodCode.builder()._strictfp();
    }

    public static Builder _int() {
        return MethodCode.builder()._int();
    }

    public static Builder _void() {
        return MethodCode.builder()._void();
    }

    public static Builder annotatedWith(Class<? extends Annotation> annotationType) {
        return MethodCode.builder().annotatedWith(annotationType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder returning(Class<?> returnType) {
        return MethodCode.builder().returning(returnType);
    }

    public static Builder returning(TypeName returnType) {
        return MethodCode.builder().returning(returnType);
    }

    public static Builder withSameAccessLevel(ExecutableElement element) {
        return new Builder().withSameAccessLevel(element);
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        if (!this.block.isEmpty()) {
            return this.acceptJavaWriter0(w).writeCodeElement(this.block);
        }
        return this.acceptJavaWriter0(w).write(';');
    }

    @Override
    public final BodyElement.Kind kind() {
        return BodyElement.Kind.METHOD;
    }

    private CodeWriter acceptJavaWriter0(CodeWriter w) {
        return w.writeAnnotations((Iterable<? extends CodeElement>)this.annotations).writeCodeElement(this.modifier).writeTypeNameAsWord(this.typeName).writeWord(this.name).writeParameters((Iterable<? extends CodeElement>)this.parameters);
    }

    public static class Builder {
        private final GrowableList<AnnotatedCode> annotations = GrowableList.newList();
        private final MethodModifier.Builder modifier = MethodModifier.builder();
        private TypeName typeName = NoTypeName._void();
        private String name = "unnamed";
        private final GrowableList<ParameterCode> parameters = GrowableList.newList();
        private final GrowableList<BlockStatement> block = GrowableList.newList();

        private Builder() {
        }

        public final Builder _public() {
            this.modifier._public();
            return this;
        }

        public final Builder _protected() {
            this.modifier._protected();
            return this;
        }

        public final Builder _private() {
            this.modifier._private();
            return this;
        }

        public final Builder _abstract() {
            this.modifier._abstract();
            return this;
        }

        public final Builder _default() {
            this.modifier._default();
            return this;
        }

        public final Builder _static() {
            this.modifier._static();
            return this;
        }

        public final Builder _final() {
            this.modifier._final();
            return this;
        }

        public final Builder _synchronized() {
            this.modifier._synchronized();
            return this;
        }

        public final Builder _native() {
            this.modifier._native();
            return this;
        }

        public final Builder _strictfp() {
            this.modifier._strictfp();
            return this;
        }

        public final Builder _int() {
            return this.setTypeNameUnchecked(PrimitiveTypeName._int());
        }

        public final Builder _void() {
            return this.returning(NoTypeName._void());
        }

        public final Builder annotatedWith(AnnotatedCode annotation) {
            this.annotations.add((Object)annotation);
            return this;
        }

        public final Builder annotatedWith(Class<? extends Annotation> annotationType) {
            return this.annotatedWith(AnnotatedCode.annotatedWith(annotationType));
        }

        public final Builder body(BlockStatement ... statements) {
            this.block.fluentAdd((Object[])statements);
            return this;
        }

        public final Builder body(Iterable<? extends BlockStatement> statements) {
            this.block.addAll(statements);
            return this;
        }

        public final MethodCode build() {
            return new MethodCode(this);
        }

        public final Builder named(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (String)"name == null");
            return this;
        }

        public final Builder returning(Class<?> returnType) {
            Preconditions.checkNotNull(returnType, (String)"returnType == null");
            return this.setTypeNameUnchecked(ClassName.ofUnchecked(returnType));
        }

        public final Builder returning(TypeName typeName) {
            Preconditions.checkNotNull((Object)typeName, (String)"typeName == null");
            return this.setTypeNameUnchecked(typeName);
        }

        public final Builder withAccessLevel(AccessLevel accessLevel) {
            Preconditions.checkNotNull((Object)((Object)accessLevel), (String)"accessLevel == null");
            switch (accessLevel) {
                case PUBLIC: {
                    return this._public();
                }
                case PROTECTED: {
                    return this._protected();
                }
                case PRIVATE: {
                    return this._private();
                }
            }
            return this;
        }

        public final Builder withAnnotations(Iterable<AnnotatedCode> annotations) {
            this.annotations.addAll(annotations);
            return this;
        }

        public final Builder withModifier(MethodModifier modifier) {
            this.modifier.withModifier(modifier);
            return this;
        }

        public final Builder withParameter(Class<?> type, String name) {
            Preconditions.checkNotNull(type, (String)"type == null");
            Preconditions.checkNotNull((Object)name, (String)"name == null");
            ClassName typeName = ClassName.ofUnchecked(type);
            ParameterCode parameter = ParameterCode.ofUnchecked(typeName, name);
            return this.withParameterUnchecked(parameter);
        }

        public final Builder withParameter(ParameterCode parameter) {
            Preconditions.checkNotNull((Object)parameter, (String)"parameter == null");
            return this.withParameterUnchecked(parameter);
        }

        public final Builder withParameter(ParameterTypeName typeName, String name) {
            Preconditions.checkNotNull((Object)typeName, (String)"typeName == null");
            Preconditions.checkNotNull((Object)name, (String)"name == null");
            ParameterCode parameter = ParameterCode.ofUnchecked(typeName, name);
            return this.withParameterUnchecked(parameter);
        }

        public final Builder withParameters(Iterable<ParameterCode> parameters) {
            Preconditions.checkNotNull(parameters, (String)"parameters == null");
            for (ParameterCode parameter : parameters) {
                this.withParameter(parameter);
            }
            return this;
        }

        public final Builder withSameAccessLevel(ExecutableElement element) {
            Preconditions.checkNotNull((Object)element, (String)"element == null");
            Set<Modifier> modifierSet = element.getModifiers();
            if (modifierSet.contains((Object)Modifier.PUBLIC)) {
                return this._public();
            }
            if (modifierSet.contains((Object)Modifier.PROTECTED)) {
                return this._protected();
            }
            if (modifierSet.contains((Object)Modifier.PRIVATE)) {
                return this._private();
            }
            return this;
        }

        final ImmutableList<AnnotatedCode> annotations() {
            return this.annotations.toImmutableList();
        }

        final Block block() {
            return Block.of(this.block);
        }

        final MethodModifier modifier() {
            return this.modifier.build();
        }

        final ImmutableList<ParameterCode> parameters() {
            return this.parameters.toImmutableList();
        }

        final String name() {
            return this.name;
        }

        private Builder setTypeNameUnchecked(TypeName typeName) {
            this.typeName = typeName;
            return this;
        }

        private Builder withParameterUnchecked(ParameterCode parameter) {
            this.parameters.add((Object)parameter);
            return this;
        }
    }
}

