/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.declaration;

import br.com.objectos.code.java.type.EnclosingElement;
import br.com.objectos.comuns.lang.Preconditions;
import javax.lang.model.element.PackageElement;

public class PackageName
implements EnclosingElement {
    private static final PackageName UNNAMED = new PackageName("");
    private final String packageName;

    private PackageName(String packageName) {
        this.packageName = packageName;
    }

    public static PackageName named(String name) {
        Preconditions.checkNotNull((Object)name, (String)"name == null");
        return new PackageName(name);
    }

    public static PackageName of(Class<?> type) {
        Preconditions.checkNotNull(type, (String)"type == null");
        return PackageName.of(type.getPackage());
    }

    public static PackageName of(Package pkg) {
        Preconditions.checkNotNull((Object)pkg, (String)"pkg == null");
        return new PackageName(pkg.getName());
    }

    public static PackageName of(PackageElement element) {
        Preconditions.checkNotNull((Object)element, (String)"element == null");
        return new PackageName(element.getQualifiedName().toString());
    }

    public static PackageName unnamed() {
        return UNNAMED;
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof PackageName)) {
            return false;
        }
        PackageName that = (PackageName)obj;
        return this.packageName.equals(that.packageName);
    }

    public final int hashCode() {
        return this.packageName.hashCode();
    }

    public final boolean is(String name) {
        return this.packageName.equals(name);
    }

    public final boolean isUnnamed() {
        return this.is("");
    }

    @Override
    public final PackageName packageName() {
        return this;
    }

    public final String toString() {
        return this.packageName;
    }
}

