/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.declaration;

import br.com.objectos.comuns.collections.ImmutableSet;
import javax.lang.model.element.Modifier;

public final class MethodModifier extends ElementModifier {

  private static final MethodModifier EMPTY = new MethodModifier(ImmutableSet.empty());

  private MethodModifier(Builder builder) {
    super(builder);
  }

  private MethodModifier(ImmutableSet<Modifier> values) {
    super(values);
  }

  public static Builder _abstract() {
    return builder()._abstract();
  }

  public static Builder _default() {
    return builder()._default();
  }

  public static Builder _final() {
    return builder()._final();
  }

  public static Builder _native() {
    return builder()._native();
  }

  public static Builder _private() {
    return builder()._private();
  }

  public static Builder _protected() {
    return builder()._protected();
  }

  public static Builder _public() {
    return builder()._public();
  }

  public static Builder _static() {
    return builder()._static();
  }

  public static Builder _strictfp() {
    return builder()._strictfp();
  }

  public static Builder _synchronized() {
    return builder()._synchronized();
  }

  public static Builder builder() {
    return new Builder();
  }

  public static MethodModifier empty() {
    return EMPTY;
  }

  public static final class Builder extends ElementModifier.Builder<MethodModifier> {

    private Builder() {}

    public final Builder _abstract() {
      return with(Modifier.ABSTRACT);
    }

    public final Builder _default() {
      return with(Modifier.DEFAULT);
    }

    public final Builder _final() {
      return with(Modifier.FINAL);
    }

    public final Builder _native() {
      return with(Modifier.NATIVE);
    }

    public final Builder _private() {
      return with(Modifier.PRIVATE);
    }

    public final Builder _protected() {
      return with(Modifier.PROTECTED);
    }

    public final Builder _public() {
      return with(Modifier.PUBLIC);
    }

    public final Builder _static() {
      return with(Modifier.STATIC);
    }

    public final Builder _strictfp() {
      return with(Modifier.STRICTFP);
    }

    public final Builder _synchronized() {
      return with(Modifier.SYNCHRONIZED);
    }

    @Override
    public final MethodModifier build() {
      return new MethodModifier(this);
    }

    private Builder with(Modifier modifier) {
      withModifier(modifier);
      return this;
    }

  }

}