/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.element;

import br.com.objectos.code.java.expression.Expressions;
import br.com.objectos.code.java.expression.FieldAccess;
import br.com.objectos.code.java.expression.FieldAccessReferenceExpression;
import br.com.objectos.code.java.expression.Identifier;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.type.ClassName;

public class QualifiedSuperKeyword extends AbstractCodeElement
    implements FieldAccessReferenceExpression {

  private final ClassName className;

  private QualifiedSuperKeyword(ClassName className) {
    this.className = className;
  }

  static QualifiedSuperKeyword ofUnchecked(ClassName className) {
    return new QualifiedSuperKeyword(className);
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    return w.writeTypeName(className)
        .spaceOff()
        .write('.')
        .spaceOff()
        .writeWord("super");
  }

  @Override
  public final FieldAccess id(Identifier id) {
    return Expressions.fieldAccess(this, id);
  }

  @Override
  public final FieldAccess id(String id) {
    return Expressions.fieldAccess(this, id);
  }

}
