/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.CodeElement;

public interface Callee extends CodeElement {

  MethodInvocation invoke(String methodName);

  MethodInvocation invoke(String methodName, Argument a1);

  MethodInvocation invoke(String methodName, Argument a1, Argument a2);

  MethodInvocation invoke(String methodName, Argument a1, Argument a2, Argument a3);

  MethodInvocation invoke(String methodName, Argument a1, Argument a2, Argument a3, Argument a4);

  MethodInvocation invoke(String methodName, Iterable<? extends Argument> args);

  MethodInvocation invoke(
      TypeWitness witness, String methodName);

  MethodInvocation invoke(
      TypeWitness witness, String methodName,
      Argument a1);

  MethodInvocation invoke(
      TypeWitness witness, String methodName,
      Argument a1, Argument a2);

  MethodInvocation invoke(
      TypeWitness witness, String methodName,
      Argument a1, Argument a2, Argument a3);

  MethodInvocation invoke(
      TypeWitness witness, String methodName,
      Argument a1, Argument a2, Argument a3, Argument a4);

  MethodInvocation invoke(
      TypeWitness witness, String methodName,
      Iterable<? extends Argument> args);

}