/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.statement.Statement;
import br.com.objectos.code.java.statement.StatementOrBlockBuilder;
import br.com.objectos.comuns.collections.ImmutableList;

public class Expression
    extends AbstractCodeElement
    implements
    ExpressionCode, Statement {

  private final ImmutableList<CodeElement> elements;

  Expression(ImmutableList<CodeElement> elements) {
    this.elements = elements;
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    for (CodeElement element : elements) {
      w.writeCodeElement(element);
    }
    return w;
  }

  @Override
  public final void acceptStatementOrBlockBuilder(StatementOrBlockBuilder builder) {
    builder.withStatement(this);
  }

}