/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractForwardingCodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.collections.StreamIterable;

public class TypeWitness extends AbstractForwardingCodeElement {

  private static final TypeWitness EMPTY = new TypeWitness(
      ImmutableCodeElement.builder()
          .withOpenAngle()
          .withSpaceOff()
          .withCloseAngle()
          .build()
  );

  private TypeWitness(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static TypeWitness witness0() {
    return EMPTY;
  }

  static TypeWitness witness0(TypeName t1) {
    return witness1(t1);
  }

  static TypeWitness witness0(TypeName t1, TypeName t2) {
    return witness1(t1, t2);
  }

  static TypeWitness witness0(TypeName t1, TypeName t2, TypeName t3) {
    return witness1(t1, t2, t3);
  }

  static TypeWitness witness0(Iterable<? extends TypeName> types) {
    return build0(
        ImmutableCodeElement.builder()
            .withOpenAngle()
            .withSpaceOff()
            .withCommaSeparated(
                StreamIterable.adapt(types).map(AbstractForwardingCodeElement::toCodeElement)
            )
            .withSpaceOff()
            .withCloseAngle()
            .build()
    );
  }

  private static TypeWitness build0(ImmutableCodeElement delegate) {
    return new TypeWitness(delegate);
  }

  private static TypeWitness witness1(TypeName... types) {
    return witness0(ImmutableList.newListWithAll(types));
  }

}
