/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.statement;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.expression.ExpressionCode;
import br.com.objectos.code.java.expression.StatementExpression;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.statement.Block.Semicolon;

public class BasicForStatement extends AbstractStatement implements ForStatement {

  private final ForInit init;
  private final ExpressionCode test;
  private final StatementExpression update;
  private final Statement statement;

  private BasicForStatement(ForInit init,
                            ExpressionCode test,
                            StatementExpression update,
                            Statement statement) {
    this.init = init;
    this.test = test;
    this.update = update;
    this.statement = statement;
  }

  static Builder builder(ForInit init, ExpressionCode test, StatementExpression update) {
    checkNotNull(init, "init == null");
    checkNotNull(test, "test == null");
    checkNotNull(update, "update == null");
    return new Builder(init, test, update);
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    w.writeFor(init, test, update);
    w.writeCodeElement(statement);
    return w;
  }

  @Override
  public final void acceptSemicolon(Semicolon semicolon) {
    statement.acceptSemicolon(semicolon);
  }

  public static class Builder {

    private final ForInit init;
    private final ExpressionCode test;
    private final StatementExpression update;

    private Builder(ForInit init, ExpressionCode test, StatementExpression update) {
      this.init = init;
      this.test = test;
      this.update = update;
    }

    public final BasicForStatement block(BlockElement... elements) {
      Block block = Block.of(elements);
      return new BasicForStatement(init, test, update, block);
    }

  }

}
