/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.statement;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.expression.Identifier;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.TypeName;

public interface LocalVariableDeclarationStatement extends BlockStatement, ForInit {

  static SimpleLocalVariableDeclaration _var(Class<?> type, Identifier id) {
    checkNotNull(type, "type == null");
    checkNotNull(id, "id == null");
    return SimpleLocalVariableDeclaration.ofUnchecked(ClassName.of(type), id.name());
  }

  static SimpleLocalVariableDeclaration _var(Class<?> type, String name) {
    checkNotNull(type, "type == null");
    checkNotNull(name, "name == null");
    return SimpleLocalVariableDeclaration.ofUnchecked(ClassName.of(type), name);
  }

  static WithInitLocalVariableDeclaration _var(Class<?> type, Identifier id,
      VariableInitializer init) {
    checkNotNull(init, "init == null");
    return _var(type, id).init(init);
  }

  static WithInitLocalVariableDeclaration _var(Class<?> type, String name,
      VariableInitializer init) {
    checkNotNull(init, "init == null");
    return _var(type, name).init(init);
  }

  static SimpleLocalVariableDeclaration _var(TypeName typeName, Identifier id) {
    checkNotNull(typeName, "typeName == null");
    checkNotNull(id, "id == null");
    return SimpleLocalVariableDeclaration.ofUnchecked(typeName, id.name());
  }

  static SimpleLocalVariableDeclaration _var(TypeName typeName, String name) {
    checkNotNull(typeName, "typeName == null");
    checkNotNull(name, "name == null");
    return SimpleLocalVariableDeclaration.ofUnchecked(typeName, name);
  }

  static WithInitLocalVariableDeclaration _var(
      TypeName typeName, Identifier id, VariableInitializer init) {
    checkNotNull(init, "init == null");
    return _var(typeName, id).init(init);
  }

  static WithInitLocalVariableDeclaration _var(
      TypeName typeName, String name, VariableInitializer init) {
    checkNotNull(init, "init == null");
    return _var(typeName, name).init(init);
  }

}
