/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.declaration;

import br.com.objectos.code.java.declaration.BodyElement;
import br.com.objectos.code.java.declaration.ClassBodyElement;
import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.statement.VariableInitializer;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.NoTypeName;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.comuns.collections.GrowableSet;
import br.com.objectos.comuns.collections.ImmutableSet;
import br.com.objectos.comuns.lang.Preconditions;
import javax.lang.model.element.Modifier;

public final class FieldCode
extends AbstractCodeElement
implements ClassBodyElement {
    private final ImmutableSet<Modifier> modifierSet;
    private final TypeName typeName;
    private final String name;
    private final VariableInitializer initializer;

    private FieldCode(Builder builder) {
        this.modifierSet = builder.modifierSet();
        this.typeName = builder.typeName;
        this.name = builder.name;
        this.initializer = builder.initializer;
    }

    public static Builder _final() {
        return FieldCode.builder()._final();
    }

    public static Builder _private() {
        return FieldCode.builder()._private();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        w.writeModifierSet((Iterable<Modifier>)this.modifierSet);
        w.writeTypeNameAsWord(this.typeName);
        w.writeWord(this.name);
        if (this.initializer != null) {
            w.writeWord('=');
            w.writePreSpace();
            w.spaceOff();
            w.writeCodeElement(this.initializer);
        }
        return w.write(';');
    }

    @Override
    public final BodyElement.Kind kind() {
        return BodyElement.Kind.FIELD;
    }

    public static class Builder {
        private final GrowableSet<Modifier> modifierSet = GrowableSet.newSet();
        private TypeName typeName = NoTypeName._void();
        private String name = "unnamed";
        private VariableInitializer initializer;

        private Builder() {
        }

        public final Builder _public() {
            return this.addModifier(Modifier.PUBLIC);
        }

        public final Builder _protected() {
            return this.addModifier(Modifier.PROTECTED);
        }

        public final Builder _private() {
            return this.addModifier(Modifier.PRIVATE);
        }

        public final Builder _static() {
            return this.addModifier(Modifier.DEFAULT);
        }

        public final Builder _final() {
            return this.addModifier(Modifier.FINAL);
        }

        public final Builder _synchronized() {
            return this.addModifier(Modifier.SYNCHRONIZED);
        }

        public final FieldCode build() {
            return new FieldCode(this);
        }

        public final Builder field(Class<?> type, String name) {
            return this.type(type).named(name);
        }

        public final Builder field(TypeName typeName, String name) {
            return this.type(typeName).named(name);
        }

        public final Builder named(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (String)"name == null");
            return this;
        }

        public final Builder type(Class<?> type) {
            Preconditions.checkNotNull(type, (String)"type == null");
            this.typeName = ClassName.ofUnchecked(type);
            return this;
        }

        public final Builder type(TypeName typeName) {
            this.typeName = (TypeName)Preconditions.checkNotNull((Object)typeName, (String)"typeName == null");
            return this;
        }

        public final Builder withInitializer(VariableInitializer initializer) {
            this.initializer = (VariableInitializer)Preconditions.checkNotNull((Object)initializer, (String)"initializer == null");
            return this;
        }

        final ImmutableSet<Modifier> modifierSet() {
            return this.modifierSet.toImmutableSet();
        }

        private Builder addModifier(Modifier modifier) {
            this.modifierSet.add((Object)modifier);
            return this;
        }
    }
}

